<?php
/**
 * @package     joomLab\Module\ContactMap
 *
 * @copyright   Copyright (C) 2025 Alexandr Novikov. All rights reserved.
 * @license     GNU General Public License version 2 or later;
 */
defined('_JEXEC') or die;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;

extract($displayData);
$input = Factory::getApplication()->getInput();
$key_metka = $input->get('metka', 'metka0', 'string');
$metka = $params->get('metka', '', 'array');
?>

<?php if($metka->{$key_metka}->image) { ?>
    <div class="contact_map_image"> <?php echo HTMLHelper::image($metka->{$key_metka}->image, '', ['loading'=>'lazy']); ?></div>
<?php } ?>
<div class="contact_map_info">
    <?php if($metka->{$key_metka}->title) { ?>
        <div class="contact_map_title"><?php echo $metka->{$key_metka}->title; ?></div>
    <?php } ?>
    <?php if($metka->{$key_metka}->address) { ?>
        <div class="contact_map_address"><?php echo $metka->{$key_metka}->address; ?></div>
    <?php } ?>
    <?php if($metka->{$key_metka}->phone) { ?>
        <div class="contact_map_phone"><?php echo $metka->{$key_metka}->phone; ?></div>
    <?php } ?>
    <?php if($metka->{$key_metka}->info) { ?>
        <div class="contact_map_dop_info"><?php echo HTMLHelper::_('content.prepare', $metka->{$key_metka}->info); ?></div>
    <?php } ?>
    <?php if($metka->{$key_metka}->link) { ?>
        <div class="contact_map_btn_link">
            <a href="<?php echo $metka->{$key_metka}->link; ?>" class="btn btn-primary">
                <?php echo $metka->{$key_metka}->text_link; ?>
            </a>
        </div>
    <?php } ?>
</div>
