/**
 * mod_joomlab_calculator
 *
 * @copyright  Copyright (C) 2025. All rights reserved.
 * @license    GNU General Public License version 2 or later;
*/
const debouncedCollectors = new Map();
function collectFormData(container) {
    const formData = new FormData();
    const inputs = container.querySelectorAll('input, select, textarea');
    const id = container.id.split("_").pop();
    inputs.forEach(input => {
        const name = input.name;
        if (!name) return;

        if (input.tagName === 'SELECT' && input.multiple) {
            // Для select multiple добавляем все выбранные значения
            const selectedOptions = Array.from(input.selectedOptions);
            selectedOptions.forEach(option => {
                formData.append(name, option.value);
            });
        } else if (input.type === 'checkbox' || input.type === 'radio') {
            if (input.checked) {
                formData.append(name, input.value);
            }
        } else {
            formData.append(name, input.value);
        }
    });
    Joomla.request({
        url: '/index.php?option=com_ajax&module=joomlab_calculator&method=load&format=raw',
        method: 'POST',
        data: formData,
        onError: function(xhr, status, error) {
            console.error('AJAX Error:', xhr, status, error);
            Joomla.renderMessages({
                error: ['Произошла ошибка при загрузке данных: ' + error]
            });
        },
        onSuccess: function(response) {
            data = JSON.parse(response);
            for (let key in data) {
                document.getElementById(`${key}_${id}`).innerHTML = `${data[key]}`;
            }
        }
    });
}
function getDebouncedCollector(container) {
    const id = container.id;
    if (!debouncedCollectors.has(id)) {
        debouncedCollectors.set(
            id,
            debounce(() => collectFormData(container), 300)
        );
    }
    return debouncedCollectors.get(id);
}
function debounce(func, delay) {
    let timeoutId;
    return function (...args) {
        clearTimeout(timeoutId);
        timeoutId = setTimeout(() => func.apply(this, args), delay);
    };
}

document.addEventListener('input', function(e) {
    const container = e.target.closest('.joomlab_calculator');
    if (!container) return;
    getDebouncedCollector(container)();
});
document.addEventListener('change', function(e) {
    const container = e.target.closest('.joomlab_calculator');
    if (!container) return;
    getDebouncedCollector(container)();
});

document.addEventListener('DOMContentLoaded', function() {
    const calculators = document.querySelectorAll('.joomlab_calculator');
    calculators.forEach(container => {
        collectFormData(container);
    });
});

//форма отправки
document.addEventListener('DOMContentLoaded', function() {
    document.querySelectorAll('.open_form').forEach(button => {
        button.addEventListener('click', function () {
            const calculatorId = this.dataset.calculatorId;
            Fancybox.show([{
                src: '#calculator_popup_'+calculatorId
            }], {
                compact: false,
                backdropClick: false,
                dragToClose: false,
                on: {
                    "close": () => {
                        document.querySelector('#calculator_popup_'+calculatorId+' .calculator_form').innerHTML = '';
                    }
                }
            });

            const formData = new FormData();
            const inputs = document.querySelector('#joomlab_calculator_'+calculatorId).querySelectorAll('input, select, textarea');
            inputs.forEach(input => {
                const name = input.name;
                if (!name) return;

                if (input.tagName === 'SELECT' && input.multiple) {
                    // Для select multiple добавляем все выбранные значения
                    const selectedOptions = Array.from(input.selectedOptions);
                    selectedOptions.forEach(option => {
                        formData.append(name, option.value);
                    });
                } else if (input.type === 'checkbox' || input.type === 'radio') {
                    if (input.checked) {
                        formData.append(name, input.value);
                    }
                } else {
                    formData.append(name, input.value);
                }
            });

            Joomla.request({
                url: '/index.php?option=com_ajax&module=joomlab_calculator&method=form&format=raw&calculatorId='+calculatorId,
                method: 'POST',
                data: formData,
                onError: function(xhr, status, error) {
                    console.error('AJAX Error:', xhr, status, error);
                    Joomla.renderMessages({
                        error: ['Произошла ошибка при загрузке данных: ' + error]
                    });
                },
                onSuccess: function(response) {
                    document.querySelector('#calculator_popup_'+calculatorId+' .calculator_form').innerHTML = response;

                    //отправляем форму
                    document.querySelectorAll('.send_form').forEach(button => {
                        button.addEventListener('click', function () {
                            const calculatorId = this.dataset.calculatorId;
                            const formData = new FormData();
                            const inputs = document.querySelector('#calculator_form_'+calculatorId).querySelectorAll('input, select, textarea');
                            inputs.forEach(input => {
                                const name = input.name;
                                if (!name) return;

                                if (input.type === 'checkbox' || input.type === 'radio') {
                                    if (input.checked) {
                                        formData.append(name, input.value);
                                    }
                                } else {
                                    formData.append(name, input.value);
                                }
                            });
                            if(validateForm()) {
                                Joomla.request({
                                    url: '/index.php?option=com_ajax&module=joomlab_calculator&method=send&format=raw&calculatorId=' + calculatorId,
                                    method: 'POST',
                                    data: formData,
                                    onError: function (xhr, status, error) {
                                        console.error('AJAX Error:', xhr, status, error);
                                        Joomla.renderMessages({
                                            error: ['Произошла ошибка при загрузке данных: ' + error]
                                        });
                                    },
                                    onSuccess: function (response) {
                                        document.querySelector('#calculator_popup_' + calculatorId + ' .calculator_form').innerHTML = response;
                                    }
                                });
                            }
                        });
                    });
                }
            });
        });
    });
});
function validateForm() {
    const form = document.querySelector('.calculator_form_send');
    const inputs = form.querySelectorAll('input');
    let isValid = true;

    inputs.forEach(input => {
        let isEmpty = false;

        // Проверка разных типов полей
        switch (input.type) {
            case 'checkbox':
                isEmpty = !input.checked;
                break;

            case 'radio':
                // Для radio проверяем, выбран ли хотя бы один в группе
                const radioGroup = form.querySelectorAll(`input[type="radio"][name="${input.name}"]`);
                const isRadioChecked = Array.from(radioGroup).some(radio => radio.checked);
                isEmpty = !isRadioChecked;
                break;

            case 'select-one':
            case 'select-multiple':
                isEmpty = !input.value;
                break;

            default:
                isEmpty = !input.value.trim();
        }

        if (isEmpty) {
            isValid = false;
            markFieldAsInvalid(input);
        } else {
            markFieldAsValid(input);
        }
    });

    return isValid;
}

function markFieldAsInvalid(input) {
    input.classList.add('invalid');

    // Для чекбоксов добавляем визуальное выделение
    if (input.type === 'checkbox' || input.type === 'radio') {
        const label = document.querySelector(`label[for="${input.id}"]`) || input.parentNode;
        label.style.color = '#a51f18';
    }
}

function markFieldAsValid(input) {
    // Убираем красную рамку
    if (input.type !== 'checkbox' && input.type !== 'radio') {
        input.style.border = '';
    }

    // Убираем красный цвет у label
    if (input.type === 'checkbox' || input.type === 'radio') {
        const label = document.querySelector(`label[for="${input.id}"]`) || input.parentNode;
        label.style.color = '';
        label.style.fontWeight = '';
    }

}