<?php
/**
 * @package     joomLab\Module\joomLabCalculator
 *
 * @copyright   Copyright (C) 2025 Alexandr Novikov. All rights reserved.
 * @license     GNU General Public License version 3 or later;
 */

namespace joomLab\Module\JoomlabCalculator\Site\Helper;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\Registry\Registry;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\Database\DatabaseInterface;
use Joomla\CMS\Helper\ModuleHelper;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Filter\OutputFilter;
use Joomla\CMS\Mail\MailTemplate;
use Joomla\CMS\Mail\MailerFactoryInterface;
use Joomla\CMS\Uri\Uri;
use joomLab\MathExecutor\MathExecutor;

class JoomlabCalculatorHelper {
    public function loadAjax() {
	    $app = Factory::getApplication();
		$moduleId = $app->getInput()->getString('moduleId', '');
	    $module = ModuleHelper::getModuleById($moduleId);
	    $moduleParams = new Registry($module->params);
		$formuls = $moduleParams->get('formuls');
	    $executor = new MathExecutor();
		//получаем формулы
	    foreach($formuls as $formula) {
		    $variables = [];
		    preg_match_all('/\{([^}]+)\}/', $formula->formula, $matches);
		    foreach($matches[1] as $varName) {
			    $inputValue = $app->getInput()->getInt($varName.'_'.$moduleId, null);
			    if (is_array($inputValue)) {
				    $numericValues = array_filter($inputValue, function($value) {
					    return is_numeric($value) || (is_string($value) && preg_match('/^-?\d*\.?\d+$/', $value));
				    });
				    if (!empty($numericValues)) {
					    $variables[$varName] = array_sum(array_map('floatval', $numericValues));
				    } else {
					    $variables[$varName] = 0;
				    }
			    } else {
				    $variables[$varName] = is_numeric($inputValue) ? (float)$inputValue : 0;
			    }
		    }

		    $expression = preg_replace_callback(
			    '/\{([^}]+)\}/',
			    function($matches) use ($variables) {
				    return $variables[$matches[1]] ?? 0;
			    },
			    $formula->formula
		    );
			$result = $executor->execute($expression);
		    try {
			    $peremennaya[OutputFilter::stringURLSafe($formula->peremennaya)] = (int)$result;
		    } catch (Throwable $e) {
			    $peremennaya[OutputFilter::stringURLSafe($formula->peremennaya)] = 0;
		    }
	    }
		$result = json_encode($peremennaya);
		return $result;
    }

	public function formAjax() {
		$app = Factory::getApplication();
		$moduleId = $app->getInput()->getString('calculatorId', '');
		$module = ModuleHelper::getModuleById($moduleId);
		$moduleParams = new Registry($module->params);

		$result = json_decode($this->loadAjax(), true);
		return LayoutHelper::render('modules.joomlab_calculator.form_mail', ['form'=> $moduleParams, 'module' => $module, 'result' => $result]);
	}

	public function sendAjax() {
		$app = Factory::getApplication();
		$moduleId = $app->getInput()->getString('calculatorId', '');
		$module = ModuleHelper::getModuleById($moduleId);
		$moduleParams = new Registry($module->params);

		//данные введенные пользователем
		$html_mail =  LayoutHelper::render('modules.joomlab_calculator.mail.html_mail', [
			'html_mail' => $moduleParams->get('form_mail'),
			'comment' => $app->getInput()->getString('calculator_comment'),
		]);

		$formData = json_decode(base64_decode($app->getInput()->getString('newFormData')));
		$formResult = json_decode(base64_decode($app->getInput()->getString('newResult')));

		//данные из калькулятора
		$html_form = LayoutHelper::render('modules.joomlab_calculator.mail.html_form', [
			'html_form' => $formData,
		]);

		//результаты расчетов
		$html_result = LayoutHelper::render('modules.joomlab_calculator.mail.html_result', [
			'html_result' =>$formResult,
		]);


		//отравляем почту
		$config = $app->getConfig();
		$sitename = $config->get('sitename');
		$mailfrom = $config->get('mailfrom');

		$mailer = Factory::getContainer()->get(MailerFactoryInterface::class)->createMailer();
		$mailTemplate = new MailTemplate('plg_system_calculator.send', $app->getIdentity()->getParam('language', $app->get('language')), $mailer);
		//получатели
		if(empty($moduleParams->get('send_mail'))) {
			$mailTemplate->addRecipient($mailfrom);
		} else {
			$recipients = explode(',', $moduleParams->get('send_mail'));
			foreach($recipients as $recipient) {
				$mailTemplate->addRecipient($recipient);
			}
		}
		$mailTemplate->addTemplateData(
			[
				'sitename' => $sitename,
				'siteurl' => Uri::base(),
				'calculator_title' => $module->title,
				'html_mail'   => $html_mail,
				'html_form' => $html_form,
				'html_result' => $html_result
			]
		);
		try {
			$mailTemplate->send();
		} catch (\Exception $e) { //если не настроена почта
			//$event->addResult('_no_mail');
		}
		return $moduleParams->get('thankyou');
	}
}