<?php
/**
 * @package     Vendor\Module\HelloWorld
 *
 * @copyright   Copyright (C) 2025 Alexandr Novikov. All rights reserved.
 * @license     GNU General Public License version 3 or later;
 */

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Filter\OutputFilter;

$moduleclass_sfx = htmlspecialchars($params->get('moduleclass_sfx', ''), ENT_COMPAT, 'UTF-8');
$fields = $params->get('calculators');
$formuls = $params->get('formuls');

$wa = Factory::getApplication()->getDocument()->getWebAssetManager();
$wa->getRegistry()->addExtensionRegistryFile('mod_joomlab_calculator');
$wa->useScript('joomlab_calculator.js');
if ($params->get('check_css'))
{
	$wa->useStyle('joomlab_calculator.css'); //подключаем стили модуля
}
if ($params->get('check_fancybox')) //подключаем FancyBox
{
	$wa->useStyle('fancybox.css');
	$wa->useScript('fancybox.js');
}
if(!$fields) return;

?>
<div id="joomlab_calculator_<?php echo $module->id ?>" class="joomlab_calculator <?php echo $moduleclass_sfx; ?>">
    <div class="calculator_block">
        <?php foreach($fields as $field) { //показ формы калькулятора ?>
            <?php echo LayoutHelper::render('modules.joomlab_calculator.fields.'.$field->field_type, ['field' => $field, 'module' => $module, 'izmerenie' => $field->izmerenie, 'multiple' => $field->check_multiple]) ?>
        <?php } ?>
        <input type="hidden" name="moduleId" value="<?php echo $module->id ?>" />
    </div>
    <div class="calculator_result">
        <?php foreach($formuls as $formula) { //показ результатов ?>
            <div class="<?php echo  OutputFilter::stringURLSafe($formula->peremennaya) ?>">
                <label><?php echo $formula->peremennaya ?></label>
                <strong id="<?php echo OutputFilter::stringURLSafe($formula->peremennaya) ?>_<?php echo $module->id ?>">0</strong>
                <span><?php echo $formula->izmerenie ?></span>
            </div>
        <?php } ?>
    </div>
    <?php if ($params->get('check_mail')) { //если включена отправка ?>
        <div class="calculator_form_btn">
            <button id="open_form_<?php echo $module->id ?>" type="button" class="open_form btn btn-primary" data-calculator-id="<?php echo $module->id ?>">
                <?php echo $params->get('form_btn') ?>
            </button>
        </div>
    <?php } ?>
</div>
<?php if ($params->get('check_mail')) { ?>
    <div id="calculator_popup_<?php echo $module->id ?>" class="calculator_popup">
        <div class="calculator_form"></div>
    </div>
<?php } ?>
