<?php
defined('_JEXEC') or die;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\Registry\Registry;

extract($displayData);
$plugin = PluginHelper::getPlugin('content', 'joomlab_gallery');
$params = new Registry($plugin->params);
$path_img = $params->get('path');

$wa = Factory::getApplication()->getDocument()->getWebAssetManager();
$wa->registerScript('joomlabiframe.js', 'media/system/js/modal-content-select.js');
$wa->getRegistry()->addExtensionRegistryFile('plg_content_joomlab_gallery');
$wa->useScript('joomlabiframe.js');
$wa->useStyle('joomlab_gallery.admin.css');
?>
<table class="table" id="fieldList">
	<thead>
        <tr>
	        <th scope="col" class="w-1">ID</th>
	        <th scope="col" class="w-1 text-center">Изображение</th>
	        <th scope="col" class="title">Наименование галереи</th>
            <th scope="col" class="w-10"></th>
            <th scope="col" class="w-10">Макет</th>
	        <th scope="col" class="w-1">Количество фото</th>
        </tr>
	</thead>
    <tbody>
        <?php foreach($list as $row => $item) {
            $img = json_decode($item->galleries,true)[0]['name'];
            ?>
            <tr class="row<?php echo $row ?>" >
                <td class="small d-none d-md-table-cell"><?php echo $item->id ?></td>
                <td class="modal_mini_img small text-center">
                    <a href="javascript:void(0)" data-content-select data-id="<?php echo $item->id ?>" data-title="<?php echo $item->name ?>" data-html="{gallery <?php echo $item->id ?>}">
                        <img loading="lazy" src="<?php echo $path_img ?>/<?php echo $item_id ?>/<?php echo $item->id ?>/mini/<?php echo $img ?>" alt="<?php echo $item->name ?>" />
                    </a>
                </td>
                <th scope="row">
                    <a href="javascript:void(0)" data-content-select data-id="<?php echo $item->id ?>" data-title="<?php echo $item->name ?>" data-html="{gallery <?php echo $item->id ?>}">
                        <?php echo $item->name ?>
                    </a>
                </th>
                <td class="small d-none d-md-table-cell">
                    <button type="button" class="btn btn-sm btn-success w-100" data-content-select data-id="<?php echo $item->id ?>" data-title="<?php echo $item->name ?>" data-html="{gallery <?php echo $item->id ?>}">
                        Вставить
                    </button>
                </td>
                <td class="small d-none d-md-table-cell"><?php echo json_decode($item->params)->maket ?></td>
                <td class="small d-none d-md-table-cell"><?php echo count(json_decode($item->galleries, true)) ?></td>
            </tr>
        <?php } ?>
    </tbody>
</table>
