document.addEventListener('DOMContentLoaded', function() {
    //клик по лайку
    document.addEventListener('click', function(event) {
        // Проверяем, был ли клик по элементу с классами only_like или other_like или их потомкам
        const likeButton = event.target.closest('.only_like, .other_like');

        if (likeButton) {
            event.preventDefault();
            const itemId = likeButton.getAttribute('data-item-id');
            const type = likeButton.getAttribute('data-type');

            Joomla.request({
                url: '/index.php?option=com_ajax&plugin=Like&format=raw&group=content&task=clickLike&item_id=' + itemId + '&type=' + type,
                method: 'GET',
                onBefore: function (xhr) {
                    const mainLike = document.querySelector(`.main_like[data-item-id="${itemId}"]`);
                    if (mainLike) {
                        mainLike.style.opacity = '0.6';
                    }
                },
                onSuccess: function(response) {
                    let data;
                    try {
                        data = JSON.parse(response);
                    } catch (e) {
                        console.error('Error parsing response:', e);
                        return;
                    }

                    // Проверяем наличие item_id в данных
                    if (data && data.item_id !== undefined) {
                        const itemId = data.item_id;
                        // Находим элемент main_like с соответствующим data-item-id
                        const mainLikeElement = document.querySelector(`.main_like[data-item-id="${itemId}"]`);
                        if (mainLikeElement) {
                            // Находим родительский блок joomlike_block
                            const block = mainLikeElement.closest('.joomlike_block');
                            if (block) {
                                // Устанавливаем основное количество лайков
                                if (data.main_count !== undefined) {
                                    const mainCountElement = block.querySelector('.main_count_like');
                                    if (mainCountElement) {
                                        mainCountElement.textContent = data.main_count;
                                    }
                                }

                                // Устанавливаем изображение для дочернего элемента main_like внутри joomlike_block
                                if (data.like_img !== undefined) {
                                    const likeImgSrc = data.like_img.split('#')[0]; // Используем только часть до #
                                    const imgElement = mainLikeElement.querySelector('img');
                                    if (imgElement) {
                                        imgElement.src = '/' + likeImgSrc;
                                    }
                                }

                                // Обновляем счетчики для other_like
                                block.querySelectorAll('.other_like').forEach(element => {
                                    const dataType = element.getAttribute('data-type');
                                    const countElement = element.querySelector('.count_mini_like');

                                    if (!dataType || !countElement) {
                                        return;
                                    }

                                    if (data.type_count && data.type_count[dataType] !== undefined) {
                                        countElement.textContent = data.type_count[dataType];
                                    } else {
                                        countElement.textContent = '0';
                                    }
                                });
                            }
                        }
                    }
                },
                onError: function(xhr, status, error) {
                    console.error('Error:', error);
                },
                onComplete: function (xhr) {
                    const mainLike = document.querySelector(`.main_like[data-item-id="${itemId}"]`);
                    if (mainLike) {
                        mainLike.style.opacity = '1';
                    }
                }
            });
        }
    });

    //появление блока с лайками
    if(document.querySelector('.all_likes')) {
        const joomlikeBlock = document.querySelector('.joomlike_block');
        const allLikes = document.querySelector('.all_likes');

        joomlikeBlock.addEventListener('mouseenter', function () {
            allLikes.style.opacity = '1';
            allLikes.style.visibility = 'visible';
        });

        joomlikeBlock.addEventListener('mouseleave', function () {
            allLikes.style.opacity = '0';
            allLikes.style.visibility = 'hidden';
        });
    }
});