<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  YandexCaptcha
 *
 * @copyright   (C) 2024 Alexandr Novikov. <https://joomlab.ru>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\FileLayout;
use Joomla\Registry\Registry;

extract($displayData);

$wa = Factory::getApplication()->getDocument()->getWebAssetManager();
$wa->registerAndUseScript('yandex_captcha', 'https://smartcaptcha.yandexcloud.net/captcha.js', [], ['defer' => 'true'], ["core"]);

$key_client = $displayData['key_client'];
?>
<div class="captcha_error"></div>
<div id="captcha-container" class="smart-captcha" data-sitekey="<?php echo $key_client ?>"></div>
