<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  YandexCaptcha
 *
 * @copyright   (C) 2024 Alexandr Novikov. <https://joomlab.ru>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;
use Joomla\CMS\Extension\PluginInterface;
use Joomla\CMS\Factory;
use Joomla\Http\HttpFactory;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;
use Joomla\Event\DispatcherInterface;
use Joomla\Plugin\Captcha\YandexCaptcha\Extension\YandexCaptcha;

return new class implements ServiceProviderInterface {

    public function register(Container $container) {
      $container->set(
        PluginInterface::class,
        function (Container $container) {
          $dispatcher = $container->get(DispatcherInterface::class);
          $plugin     = new YandexCaptcha (
            $dispatcher,
            (array) PluginHelper::getPlugin('captcha', 'yandexcaptcha'),
			new HttpFactory
          );
          $plugin->setApplication(Factory::getApplication());
          return $plugin;
        }
      );
    }
};