<?php defined('_JEXEC') or die;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;

extract($displayData);

$app = Factory::getApplication();

$wa = Factory::getApplication()->getDocument()->getWebAssetManager();
$wa->getRegistry()->addExtensionRegistryFile('plg_system_ajax_pagination');
$wa->useStyle('ajax_pagination.css');
?>
<div id="ajax_pagination_preloader" style="display:none">
	<?php echo HTMLHelper::image($params->get('preloader'), 'preloader', ['loading'=>'lazy']); ?>
</div>
<div class="btn btn-primary ajax_pagination_button fon_btn blick uk-button uk-button-primary" data-total = '<?php echo $total?>' data-limit="<?php echo $limit ?>" data-link="">
	<?php echo Text::_($params->get('text_button')) ?>
</div>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const button = document.querySelector('.ajax_pagination_button');
        button.addEventListener('click', function () {
            const data = this.dataset;
            const total = parseInt(data.total);
            const limit = parseInt(data.limit);
            document.getElementById('ajax_pagination_preloader').style.display = 'block';
            Joomla.request({
                url: '<?php echo $link?>?start='+ limit+'&tmpl=component',
                method: 'GET',
                onSuccess: function (response) {
                    const tempDiv = document.createElement('div');
                    tempDiv.innerHTML = response;
                    const newItems = tempDiv.querySelector('<?php echo $params->get('container_items') ?>')?.innerHTML;
                    if (newItems) {
                        //добавляем новые материалы
                        document.querySelector('<?php echo $params->get('container_items') ?>').insertAdjacentHTML('beforeend', newItems);
                        const newLimit = limit + <?php echo $limit ?>;
                        button.setAttribute('data-limit', newLimit);
                    }
                    document.getElementById('ajax_pagination_preloader').style.display = 'none';
                    if(total <= (limit + <?php echo $limit ?>)){
                        button.remove();
                    }
                },
                onError: function (xhr, status, error) {
                    console.log(error);
                    Joomla.renderMessages({
                        error: ['Произошла ошибка при отправке запроса']
                    });
                }
            });
        });
    });
</script>