<?php defined('_JEXEC') or die;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;
extract($displayData);

$app = Factory::getApplication();

$wa = Factory::getApplication()->getDocument()->getWebAssetManager();
$wa->getRegistry()->addExtensionRegistryFile('plg_system_ajax_pagination');
$wa->useStyle('ajax_pagination.css');

?>
<div id="ajax_pagination_preloader" style="display:none">
	<img loading="lazy" src="/images/preloader.svg" alt="preloader" />
</div>
<div class="ajax_pagination_block" data-total = '<?php echo $total?>' data-limit="<?php echo $limit ?>" data-link=""></div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const paginationBlock = document.querySelector('.ajax_pagination_block');
        if (!paginationBlock) return;

        const data = paginationBlock.dataset;
        let total = parseInt(data.total);
        let limit = parseInt(data.limit);
        const preloader = document.getElementById('ajax_pagination_preloader');
        const container = document.querySelector('<?php echo $params->get("container_items") ?>');
        let isLoading = false;

        // Создаем Intersection Observer для отслеживания появления блока
        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting && !isLoading && limit < total) {
                    loadMoreContent();
                }
            });
        }, {
            threshold: 0.1
        });

        observer.observe(paginationBlock);

        function loadMoreContent() {
            isLoading = true;
            preloader.style.display = 'block';

            Joomla.request({
                url: '<?php echo $link ?>?start=' + limit + '&tmpl=component',
                method: 'GET',
                onSuccess: function(response) {
                    const tempDiv = document.createElement('div');
                    tempDiv.innerHTML = response;
                    const newItems = tempDiv.querySelector('<?php echo $params->get("container_items") ?>')?.innerHTML;

                    if (newItems) {
                        container.insertAdjacentHTML('beforeend', newItems);
                        limit = limit + <?php echo $limit ?>; // Обновляем переменную limit
                        paginationBlock.setAttribute('data-limit', limit); // Обновляем data-атрибут
                    }

                    if (limit >= total) {
                        paginationBlock.style.display = 'none';
                    }
                },
                onError: function(xhr, status, error) {
                    console.error(error);
                    Joomla.renderMessages({
                        error: ['Произошла ошибка при загрузке данных']
                    });
                },
                onComplete: function() {
                    isLoading = false;
                    preloader.style.display = 'none';
                }
            });
        }

        // Исправленная проверка видимости элемента
        if (limit < total && isElementInViewport(paginationBlock)) {
            // Небольшая задержка для корректной работы
            setTimeout(loadMoreContent, 100);
        }

        function isElementInViewport(el) {
            const rect = el.getBoundingClientRect();
            return (
                rect.top <= (window.innerHeight || document.documentElement.clientHeight) &&
                rect.bottom >= 0
            );
        }
    });
</script>
