<?php
/**
 * @package     joomLab.Plugin
 * @subpackage  System.AjaxPagination
 *
 * @copyright   (C) 2025 Alexandr Novikov. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace joomLab\Plugin\System\AjaxPagination\Extension;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Event\SubscriberInterface;
use Joomla\CMS\Event\Application\AfterDispatchEvent;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\Database\DatabaseInterface;
use Joomla\CMS\Uri\Uri;
class AjaxPagination extends CMSPlugin implements SubscriberInterface
{
    protected $autoloadLanguage = true;
    public static function getSubscribedEvents(): array
    {
        return [
            'onAfterDispatch' => 'onAfterDispatch',
        ];
    }

    public function onAfterDispatch(AfterDispatchEvent $event): void
    {
	    $app = $this->getApplication();
	    if ($app->isClient('site') == false || $app->input->get('view') != 'category') {
		    return;
	    }

		$type = $this->params->get('type_pagination');
		$container_pagination = $this->params->get('container_pagination');
	    $container_items = $this->params->get('container_items');

		//получаем лимит из пункта меню или из компонента
	    $menuItem = $app->getMenu()->getActive();
	    $params_menu = $menuItem->getParams();
	    $params_content = ComponentHelper::getParams('com_content');
	    $limit_leading = $params_menu->get('num_leading_articles', $params_content->get('num_leading_articles'));
	    $limit_intro = $params_menu->get('num_intro_articles', $params_content->get('num_intro_articles'));
		$limit = (int)$limit_leading + (int)$limit_intro;

		//получаем общее кол-во материалов в этой категории и во всех подкатегориях
	    $db = Factory::getContainer()->get(DatabaseInterface::class);
	    $category_id = (int) $app->input->getInt('id');
	    $query = $db->getQuery(true);
		if($params_content->get('show_subcategory_content') == '-1')
		{
			//если получаем материалы из всех подкатегорий
			$subQuery = $db->getQuery(true);
			$subQuery->select('id')
				->from($db->quoteName('#__categories'))
				->where($db->quoteName('lft') . ' >= (SELECT lft FROM ' . $db->quoteName('#__categories') . ' WHERE id = ' . $category_id . ')')
				->where($db->quoteName('rgt') . ' <= (SELECT rgt FROM ' . $db->quoteName('#__categories') . ' WHERE id = ' . $category_id . ')')
				->where($db->quoteName('extension') . ' = ' . $db->quote('com_content'));
			$query->select('COUNT(*) AS total')
				->from($db->quoteName('#__content'))
				->where($db->quoteName('catid') . ' IN (' . $subQuery . ')')
				->where($db->quoteName('state') . ' = 1');
		} else {
			//если получаем изодной категории
			$query->select('COUNT(*) AS total')
				->from($db->quoteName('#__content'))
				->where($db->quoteName('catid') . ' = ' . $category_id)
				->where($db->quoteName('state') . ' = 1');
		}
	    $db->setQuery($query);
	    $total = $db->loadResult();

		//получаем текущую ссылку
	    $currentUri = Uri::getInstance();
	    $link = $currentUri->toString(['path', 'query', 'fragment']);

		//добавляем ajax пагинацию
	    $document = $app->getDocument();
	    $body = $document->getBuffer('component');
		//определяем контейнер
	    if(isset(explode('.', $container_pagination)[1])){
			$block = 'class';
			$class = explode('.', $container_pagination)[1];
	    }
	    if(isset(explode('#', $container_pagination)[1])){
		    $block = 'id';
		    $class = explode('.', $container_pagination)[1];
	    }
	    $newPagination = preg_replace(
		    '/(<div[^>]*'.$block.'="[^"]*'.$class.'[^"]*"[^>]*>)/i',
		    '$1'. LayoutHelper::render('plugins.system.ajax_pagination.'.$type, ['total' => $total, 'limit' => $limit, 'link'=> $link, 'params' => $this->params]),
		    $body,
		    1
	    );
		/*
	    $newPagination = preg_replace(
		    '/(<div[^>]*'.$block.'="[^"]*'.$class.'[^"]*"[^>]*>).*?(<\/div>)/is',
		    '$1'. LayoutHelper::render('plugins.system.ajax_pagination.'.$type, ['total' => $total, 'limit' => $limit, 'link'=> $link, 'params' => $this->params]),
		    $body,
		    1
	    ); */
	    $document->setBuffer($newPagination, 'component');
    }
}