<?php
/**
 * @package     joomLab.Plugin
 * @subpackage  System.Mailauthorstatecontent
 *
 * @copyright   (C) 2025 Alexandr Novikov. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace joomLab\Plugin\System\Mailauthorstatecontent\Extension;

defined('_JEXEC') or die;

use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Event\SubscriberInterface;
use Joomla\Event\Event;
use Joomla\CMS\Mail\MailerFactoryInterface;
use Joomla\CMS\Mail\MailTemplate;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;
use Joomla\Database\DatabaseInterface;
use Joomla\CMS\Router\Route;
use Joomla\Component\Content\Site\Helper\RouteHelper;

class Mailauthorstatecontent extends CMSPlugin implements SubscriberInterface
{
    protected $autoloadLanguage = true;

    public static function getSubscribedEvents(): array
    {
        return [
            'onContentChangeState' => 'onContentChangeState',
            'onContentBeforeSave' => 'onContentBeforeSave'
        ];
    }

    //из списка материалов
    public function onContentChangeState(Event $event): void
    {
        [$context, $pks, $value] = array_values($event->getArguments());
        if($context !== 'com_content.article') {
            return;
        }
        $app = $this->getApplication();
        $db = Factory::getContainer()->get(DatabaseInterface::class);
        if(!$app->language){
            $language = 'ru-RU';
        }
        $uri = Uri::getInstance();
        $domen = $uri->toString(array('scheme','host'));

        if($value == 0) { $state = Text::_('PLG_SYSTEM_MAILAUTHORSTATECONTENT_UNPUBLICK'); }
        if($value == 1) { $state = Text::_('PLG_SYSTEM_MAILAUTHORSTATECONTENT_PUBLICK'); }
        if($value == 2) { $state = Text::_('PLG_SYSTEM_MAILAUTHORSTATECONTENT_ARCHIV'); }
        if($value == -2) { $state = Text::_('PLG_SYSTEM_MAILAUTHORSTATECONTENT_TRASH'); }

        $mailer = Factory::getContainer()->get(MailerFactoryInterface::class)->createMailer();
        $mailTemplate = new MailTemplate('plg_system_mailauthorstatecontent.send', $language, $mailer);
        foreach ($pks as $key=>$item_id) {
            $db->setQuery("SELECT `id`, `alias`, `title`, `catid`, `language`, `created_by` FROM `#__content` WHERE `id` = '{$item_id}'");
            $item = $db->loadObjectList()[0];
            $slug = $item->id.':'.$item->alias;
            $link = $domen .''. Route::link('site', RouteHelper::getArticleRoute($slug, $item->catid, $item->language));
            $user  = Factory::getUser($item->created_by);
            $mailTemplate->addRecipient($user->email);
            $mailTemplate->addTemplateData(
                [
                    'sitename' => $app->get('sitename'),
                    'siteurl' => $domen,
                    'author_name' => $user->name,
                    'article_title' => $item->title,
                    'article_url' => $link,
                    'state' => $state,
                ]
            );
            try {
                $mailTemplate->send();
                $app->enqueueMessage(Text::_('PLG_SYSTEM_MAILAUTHORSTATECONTENT_NOTIFICATION'));
            } catch (\Exception $e) {
                $app->enqueueMessage("Failed to send mail, " . $e->getMessage(), 'error');
            }

        }
    }
    //из материала
    public function onContentBeforeSave(Event $event): void
    {
        $app = $this->getApplication();
        $user = $app->getIdentity();
        $db = Factory::getContainer()->get(DatabaseInterface::class);

        [$context, $item, $isNew, $data] = array_values($event->getArguments());

        $db->setQuery("SELECT `state` FROM `#__content` WHERE `id` = '{$item->id}'");
        $old_state = $db->loadResult();
        if($context !== 'com_content.article' or $isNew == true or $old_state == $item->state) {
            return;
        }

        if(!$app->language){
            $language = 'ru-RU';
        }

        $uri = Uri::getInstance();
        $domen = $uri->toString(array('scheme','host'));

        if($item->state == 0) { $state = Text::_('PLG_SYSTEM_MAILAUTHORSTATECONTENT_UNPUBLICK'); }
        if($item->state == 1) { $state = Text::_('PLG_SYSTEM_MAILAUTHORSTATECONTENT_PUBLICK'); }
        if($item->state == 2) { $state = Text::_('PLG_SYSTEM_MAILAUTHORSTATECONTENT_ARCHIV'); }
        if($item->state == -2) { $state = Text::_('PLG_SYSTEM_MAILAUTHORSTATECONTENT_TRASH'); }

        $mailer = Factory::getContainer()->get(MailerFactoryInterface::class)->createMailer();
        $mailTemplate = new MailTemplate('plg_system_mailauthorstatecontent.send', $language, $mailer);

        $slug = $item->id.':'.$item->alias;
        $link = $domen .''. Route::link('site', RouteHelper::getArticleRoute($slug, $item->catid, $item->language));
        $author  = Factory::getUser($item->created_by);
        $mailTemplate->addRecipient($author->email);
        $mailTemplate->addTemplateData(
                [
                    'sitename' => $app->get('sitename'),
                    'siteurl' => $domen,
                    'author_name' => $author->name,
                    'article_title' => $item->title,
                    'article_url' => $link,
                    'state' => $state,
                ]
            );
        try {
            $mailTemplate->send();
            $app->enqueueMessage(Text::_('PLG_SYSTEM_MAILAUTHORSTATECONTENT_NOTIFICATION'));
        } catch (\Exception $e) {
            $app->enqueueMessage("Failed to send mail, " . $e->getMessage(), 'error');
        }
    }
}