document.addEventListener('DOMContentLoaded', function() {
    File();
    const deleteButtonsAvatar = document.querySelectorAll('.delete_avatar');
    deleteButtonsAvatar.forEach(function(button) {
        button.addEventListener('click', function (e) {
            e.preventDefault();
            const userId = button.getAttribute('data-user-id');
            console.log(userId);

            Joomla.request({
                url: '/index.php?option=com_ajax&plugin=JoomlabAvatar&format=raw&group=user&task=deleteAvatar&userId=' + userId,
                method: 'GET',
                onSuccess: function(response) {
                    if(response == 'go_delete') {
                        document.getElementById("avatar-container").innerHTML = '';
                        document.querySelector(".delete_avatar").remove();
                    }
                },
                onError: function(xhr, status, error) {
                    console.error('Error:', error);
                }
            });
        })
    });
});
function File() {
    const fileInput = document.getElementById("avatar");
    const avatarContainer = document.querySelector(".file_add_avatar");
    const imageContainer = document.getElementById("avatar-container");
    const submitButton = document.getElementById("submitButton");
    const selectedFiles = [];

    if (fileInput) {
        fileInput.addEventListener("change", function(event) {
            const files = event.target.files;
            const invalidFiles = [];

            for (let i = 0; i < files.length; i++) {
                const file = files[i];
                if (file.type.startsWith("image/") && !selectedFiles.includes(file)) {
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        const img = document.createElement("img");
                        img.src = e.target.result;

                        const imageItem = document.createElement("div");
                        imageItem.classList.add("image-item");
                        imageItem.appendChild(img);

                        const deleteButton = document.createElement("button");
                        deleteButton.setAttribute("type", "button");
                        deleteButton.classList.add("delete-button");
                        deleteButton.innerText = "×";
                        deleteButton.addEventListener("click", function() {
                            imageContainer.removeChild(imageItem);
                            deleteButton.remove();
                            const index = selectedFiles.indexOf(file);
                            if (index > -1) {
                                selectedFiles.splice(index, 1);
                                updateFileInput();
                            }
                        });

                        // Добавляем кнопку удаления в начало контейнера .file_add_avatar
                        avatarContainer.insertBefore(deleteButton, avatarContainer.firstChild);

                        imageContainer.appendChild(imageItem);
                    };
                    reader.readAsDataURL(file);
                    selectedFiles.push(file);
                } else {
                    invalidFiles.push(file.name);
                }
            }
            if (invalidFiles.length > 0) {
                document.getElementById("error_file").style.display = "block";
                document.getElementById("error_file").innerText = "Пожалуйста, выберите только изображения. Невалидные файлы: " + invalidFiles.join(", ");
            } else {
                document.getElementById("error_file").style.display = "none";
            }
            updateFileInput();
        });

        function updateFileInput() {
            const dataTransfer = new DataTransfer();
            selectedFiles.forEach(file => {
                dataTransfer.items.add(file);
            });
            fileInput.files = dataTransfer.files;
        }
    }
}