<?php
/**
 * @package     joomLab.Plugin
 * @subpackage  User.JoomlabAvatar
 *
 * @copyright   (C) 2025 Alexandr Novikov. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace joomLab\Plugin\User\JoomlabAvatar\Extension;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Event\SubscriberInterface;
use Joomla\CMS\Event\Model\PrepareFormEvent;
use Joomla\Event\Event;
use Joomla\CMS\Image\Image;
use Joomla\Database\DatabaseInterface;
use Joomla\Component\Fields\Administrator\Helper\FieldsHelper;
use Joomla\Component\Fields\Administrator\Model\FieldModel;
use Joomla\Utilities\ArrayHelper;
use Joomla\Filesystem\File;
use Joomla\CMS\Filesystem\Folder;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\Registry\Registry;

class JoomlabAvatar extends CMSPlugin implements SubscriberInterface
{
	protected $autoloadLanguage = true;
	public static function getSubscribedEvents(): array
	{
		return [
			'onContentPrepareForm' => 'onContentPrepareForm',
			'onUserAfterSave' => 'onUserAfterSave',
			'onUserAfterDelete' => 'onUserAfterDelete',
			'onAjaxJoomlabAvatar' => 'onAjaxJoomlabAvatar'
		];
	}

	public function onContentPrepareForm(PrepareFormEvent $event)
	{
		$form    = $event->getForm();
		$context = $form->getName();

		if (!\in_array($context, ['com_users.profile', 'com_users.user', 'com_users.registration']))
		{
			return;
		}
		$app = $this->getApplication();
		if ($app->isClient('site'))
		{
			$this->loadLanguage();

			// Добавляем поле avatar
			$form->load('
            <form>
            	<fields name="jform">
        			<fieldset name="default">
	                <field
	                    name="avatar"
	                    type="avatar"
	                    addfieldprefix="joomLab\Plugin\User\JoomlabAvatar\Fields"
	                    label="PLG_USER_JOOMLAB_AVATAR_LABEL"
	                    required="false"
	                    description="PLG_USER_JOOMLAB_AVATAR_DESC"
	                />
                </fieldset>
                </fields>
            </form>', true);
		}
	}
	public function onUserAfterSave(Event $event)
	{
		$user_id = $event->getArguments()['subject']['id'];
		$isNew = $event->getArguments()['isNew'];

		$app = $this->getApplication();
		$file = $app->getInput()->files->get('jform')['avatar'];

		$users_fields = FieldsHelper::getFields('com_users.user', ['id' => $user_id], true);
		$user_fields = ArrayHelper::pivot($users_fields, 'name');
		$media_param   = ComponentHelper::getParams('com_media', true);

		$plugin = PluginHelper::getPlugin('user','joomlab_avatar');
		$param_avatar = new Registry($plugin->params);
		$path = JPATH_BASE.'/'.$param_avatar->get('path_avatar', 'images/avatars');
		$size_mini = explode('/', $param_avatar->get('size_avatar', '150/150'));

		if(!empty($file)) {
			if(!empty($file['name'])) {
				$filename = File::makeSafe($file['name']);
				$filename = str_replace(' ', '-', $filename);
				$size     = $file['size'];
				$dir = $path . '/' . $user_id . '/mini';

				//проверяем размер
				$sizeOk = true;
				if ($size > $media_param->get('upload_maxsize') * 1048576) {
					$sizeOk = false;
				}
				//проверяем расширение
				$uploadedFileNameParts = explode('.', $filename);
				$uploadedFileExtension = array_pop($uploadedFileNameParts);
				$validFileExts         = explode(',', $media_param->get('image_extensions'));
				$extOk                 = false;
				foreach ($validFileExts as $key => $value) {
					if (preg_match("/$value/i", $uploadedFileExtension)) {
						$extOk = true;
						break;
					}
				}
				//проверяем тип файла
				$uploadedFileMimeType = $file['type'];
				$validMimeTypes       = explode(',', $media_param->get('upload_mime'));
				$mimeOk               = false;
				foreach ($validMimeTypes as $key => $value) {
					$escapedValue = preg_quote($value, '/');
					if (preg_match("/$escapedValue/i", $uploadedFileMimeType)) {
						$mimeOk = true;
						break;
					}
				}
				//загружаем файл
				$src  = $file['tmp_name'];
				$desc = $path . '/' . $user_id . '/' . $filename;
				if ($extOk == true and $sizeOk == true and $mimeOk == true) {
					//удаляем старый аватар
					if (Folder::exists($path . '/' . $user_id)) //удаляем изображения
					{
						Folder::delete($path . '/' . $user_id);
					}
					//создаем путь
					if (!Folder::exists($dir)) //если нет директории-создаем
					{
						Folder::create($dir);
					}
					if (File::upload($src, $desc)) {
						$imagePath = $desc;
						$image     = new Image($imagePath);
						$newWidth  = $size_mini[0];
						$newHeight = $size_mini[1];
						$image->cropResize($newWidth, $newHeight, false);
						$image->toFile($path . '/' . $user_id . '/mini/' . $filename);
					}
					if (isset($user_fields['avatar'])) { //добавляем аватар, если все ок
						// Значение для установки
						$value = [
							'imagefile' => $param_avatar->get('path_avatar', 'images/avatars') . '/' . $user_id . '/mini/' . $filename,
							'alt_text'  => ''
						];
						$value = json_encode($value);

						$mvcFactory = $app->bootComponent('com_fields')->getMVCFactory();
						$model      = $mvcFactory->createModel('Field', 'Administrator', ['ignore_request' => true]);
						$model->setFieldValue(
							$user_fields['avatar']->id,
							$user_id,
							$value
						);
					}
				} else { //добавляем no_avatar если проверка не пройдена
					$value = [
						'imagefile' => $param_avatar->get('no_avatar', 'images/avatars/no_avatar.png'),
						'alt_text'  => ''
					];
					$value = json_encode($value);

					$mvcFactory = $app->bootComponent('com_fields')->getMVCFactory();
					$model      = $mvcFactory->createModel('Field', 'Administrator', ['ignore_request' => true]);
					$model->setFieldValue(
						$user_fields['avatar']->id,
						$user_id,
						$value
					);
				}
			} else { //добавляем no_avatar если пользователь оставил поле пустым
				if ($isNew and isset($user_fields['avatar']))
				{
					$value = [
						'imagefile' => $param_avatar->get('no_avatar', 'images/avatars/no_avatar.png'),
						'alt_text'  => ''
					];
					$value = json_encode($value);

					$mvcFactory  = $app->bootComponent('com_fields')->getMVCFactory();
					$model       = $mvcFactory->createModel('Field', 'Administrator', ['ignore_request' => true]);
					$model->setFieldValue(
						$user_fields['avatar']->id,
						$user_id,
						$value
					);
				}
			}
		}
	}
	public function onUserAfterDelete(Event $event)
	{
		[$user, $success, $msg] = array_values($event->getArguments());
		$user_id = ArrayHelper::getValue($user, 'id', 0, 'int');
		$plugin = PluginHelper::getPlugin('user','joomlab_avatar');
		$param_avatar = new Registry($plugin->params);
		$path = JPATH_ROOT.'/'.$param_avatar->get('path_avatar', 'images/avatars').'/'.$user_id;
		if (Folder::exists($path)) //удаляем изображения
		{
			Folder::delete($path);
		}
	}

	public function onAjaxJoomlabAvatar(Event $event) {
		$app = $this->getApplication();
		$task = $app->getInput()->get('task', '', 'string');
		if($task == 'deleteAvatar') {
			$user_id = $app->getInput()->getInt('userId', '');
			$users_fields = FieldsHelper::getFields('com_users.user', ['id' => $user_id], true);
			$user_fields = ArrayHelper::pivot($users_fields, 'name');
			$plugin = PluginHelper::getPlugin('user','joomlab_avatar');
			$param_avatar = new Registry($plugin->params);
			$path = JPATH_ROOT.'/'.$param_avatar->get('path_avatar', 'images/avatars').'/'.$user_id;
			$value = [
				'imagefile' => $param_avatar->get('no_avatar', 'images/avatars/no_avatar.png'),
				'alt_text'  => ''
			];
			$value = json_encode($value);
			//заменяем на no_avatar
			$mvcFactory  = $app->bootComponent('com_fields')->getMVCFactory();
			$model       = $mvcFactory->createModel('Field', 'Administrator', ['ignore_request' => true]);
			$model->setFieldValue(
				$user_fields['avatar']->id,
				$user_id,
				$value
			);

			if (Folder::exists($path)) //удаляем изображения
			{
				if(Folder::delete($path)){
					$event->addResult('go_delete');
				}
			} else {
				$event->addResult('error_delete');
			}
		}
	}
}