<?php
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\Component\Fields\Administrator\Helper\FieldsHelper;
use Joomla\Utilities\ArrayHelper;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\Registry\Registry;

extract($displayData);

$app = Factory::getApplication();
$wa = $app->getDocument()->getWebAssetManager();
$wa->getRegistry()->addExtensionRegistryFile('plg_user_joomlab_avatar');
$wa->useStyle('joomlab_avatar.css');
$wa->useScript('joomlab_avatar.js');

$plugin = PluginHelper::getPlugin('user','joomlab_avatar');
$param_avatar = new Registry($plugin->params);

$users_fields = FieldsHelper::getFields('com_users.user', ['id' => $app->getIdentity()->id], true);
$user_fields = ArrayHelper::pivot($users_fields, 'name');
$no_avatar = HTMLHelper::image($param_avatar->get('no_avatar', 'images/avatars/no_avatar.png'), 'avatar', ['loading'=>'lazy']);

?>
<div class="photo_block">
	<div id="error_file" class="alert alert-danger" style="display: none"></div>
	<div class="file_add_avatar">
		<?php if(!empty($user_fields['avatar']->value) and json_decode($user_fields['avatar']->rawvalue)->imagefile != $param_avatar->get('no_avatar', 'images/avatars/no_avatar.png')) {?><button class="delete_avatar" type="button" data-user-id="<?php echo $app->getIdentity()->id ?>">×</button><?php } ?>
		<label id="file_label_avatar" for="avatar">
            <span id="avatar-container"><?php if(!empty($user_fields['avatar']->value)) {?><?php echo $user_fields['avatar']->value ?><?php } ?></span>
            <?php echo $no_avatar ?>
        </label>
		<input type="file" id="avatar" name="jform[avatar]" style="display:none;" tabindex="-1"  />
	</div>
</div>