<?php
namespace joomLab\Plugin\User\JoomlabAvatar\Fields;
use Joomla\CMS\Form\FormField;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class AvatarField extends FormField
{
	protected $type = 'Avatar';
	protected $accept;
	protected $layout = 'plugins.user.joomlab_avatar.field.avatar';
	public function __get($name)
	{
		if ($name === 'accept') {
			return $this->accept;
		}
		return parent::__get($name);
	}
	public function __set($name, $value)
	{
		switch ($name) {
			case 'accept':
				$this->accept = (string) $value;
				break;

			default:
				parent::__set($name, $value);
		}
	}
	public function setup(\SimpleXMLElement $element, $value, $group = null)
	{
		$return = parent::setup($element, $value, $group);

		if ($return) {
			$this->accept = (string) $this->element['accept'];
		}
		return $return;
	}
	protected function getInput()
	{
		return $this->getRenderer($this->layout)->render($this->collectLayoutData());
	}
	protected function getLayoutData()
	{
		$data = parent::getLayoutData();

		$extraData = [
			'accept'   => $this->accept,
			'multiple' => $this->multiple,
		];
		return array_merge($data, $extraData);
	}
}