<?php
/**
 * @package     joomLab.Gallery
 * @subpackage  joomLab.Gallery.Slide
 *
 * @copyright   (C) 2025 Alexandr Novikov. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\Registry\Registry;

extract($displayData);

$plugin = PluginHelper::getPlugin('content', 'joomlab_gallery');
$params = new Registry($plugin->params);
$path_img = $params->get('path', 'images/gallery');
$check_swiper = $params->get('check_swiper', 1);
$check_fancybox = $params->get('check_fancybox', 1);

$wa = Factory::getApplication()->getDocument()->getWebAssetManager();
$wa->getRegistry()->addExtensionRegistryFile('plg_content_joomlab_gallery');
if($check_swiper == 1) { //подключаем swiper
	$wa->useStyle('joomlab_gallery.swiper.css');
	$wa->useScript('joomlab_gallery.swiper.js');
}
if($check_fancybox == 1) { //подключаем fancybox
	$wa->useStyle('joomlab_gallery.fancybox.css');
	$wa->useScript('joomlab_gallery.fancybox.js');
}
$wa->useStyle('joomlab_gallery.css');

$list = json_decode($gallery->galleries);
$param_gallery =  json_decode($gallery->params);
$width = 'auto';
if($param_gallery->position != 'w100') {
    $width = $param_gallery->number * explode('/', $param_gallery->resize)[0].'px';
}
//dump($param_gallery)
?>
<div class="gallery <?php echo $param_gallery->position ?>" style="width:<?php echo $width ?>; max-width:100%!important">
<div id="gallery_<?php echo $gallery->id ?>" class="slide">
	<div class="swiper gallery_<?php echo $gallery->id ?>">
		<div class="swiper-wrapper">
			<?php foreach($list as $item) {
				if(empty($item->description)){
					$alt = $item->name;
                    $caption = '';
				} else {
					$alt = $item->description;
                    $caption = $item->description;
				}
				?>
				<div class="swiper-slide">
					<a
                        class="fancy_<?php echo $gallery->id ?>"
                        data-fancybox="gallery_<?php echo $gallery->id ?>"
                    	<?php if(!empty($caption)) { ?>data-caption="<?php echo $caption ?>"<?php } ?>
                        data-src="/<?php echo $path_img ?>/<?php echo $gallery->item_id ?>/<?php echo $gallery->id ?>/<?php echo $item->name ?>">
						<img loading="lazy" src="/<?php echo $path_img ?>/<?php echo $gallery->item_id ?>/<?php echo $gallery->id ?>/mini/<?php echo $item->name ?>" alt="<?php echo $alt ?>" />
					</a>
				</div>
			<?php } ?>
		</div>
		<?php if($param_gallery->arrows == 1) { ?>
			<div class="swiper-button-next"></div>
			<div class="swiper-button-prev"></div>
		<?php } ?>
		<?php if($param_gallery->pagination == 1) { ?>
			<div class="swiper-pagination"></div>
        <?php } ?>
	</div>
</div>
</div>
<script>
    var swiper = new Swiper(".gallery_<?php echo $gallery->id ?>", {
        spaceBetween: 15,
        freeMode: true,
        loop: <?php echo $param_gallery->loop ?>,
	    <?php if($param_gallery->pagination == 1) { ?>
        pagination: {
            el: ".swiper-pagination",
            clickable: true,
            <?php if($param_gallery->type_pagination == 'dinamic') { ?>
                dynamicBullets: true,
            <?php } ?>
	        <?php if($param_gallery->type_pagination == 'progressbar' or $param_gallery->type_pagination == 'fraction') { ?>
                type: "<?php echo $param_gallery->type_pagination ?>",
            <?php } ?>
	        <?php if($param_gallery->type_pagination == 'custom') { ?>
                renderBullet: function (index, className) {
                    return '<span class="' + className + '">' + (index + 1) + "</span>";
                },
            <?php } ?>
        },
        <?php } ?>
	    <?php if($param_gallery->arrows == 1) { ?>
        navigation: {
            nextEl: ".swiper-button-next",
            prevEl: ".swiper-button-prev",
        },
	    <?php } ?>
	    <?php if($param_gallery->autoplay == 1) { ?>
        autoplay: {
            delay: <?php echo $param_gallery->time_autoplay ?>,
            disableOnInteraction: false,
        },
        <?php } ?>
        "breakpoints": {
            "320": {
                "slidesPerView": 2,
            },
            "768": {
                "slidesPerView": 3,
            },
            "982": {
                "slidesPerView": 4,
            },
            "1024":{
                "slidesPerView": <?php echo $param_gallery->number ?>,
            }
        }
    });
    <?php if($check_fancybox == 1) { ?>
        Fancybox.bind('.fancy_<?php echo $gallery->id ?>', {
            Carousel: {
                // настройки карусели
            },
            Toolbar: {
                display: {
                    left: [
                        <?php if($param_gallery->fancy_counter == 1) { ?>
                            "infobar"
                        <?php } ?>
                    ],
                    middle: [],
                    right: [
	                    <?php if($param_gallery->fancy_download == 1) { ?>
                        "download",
	                    <?php } ?>
                        "close",
                    ]
                },
            },
	        <?php if($param_gallery->fancy_thumb == 0) { ?>
            Thumbs: {
                type: false
            },
	        <?php } ?>
        });
    <?php } ?>
</script>