<?php
/**
 * @package     joomLab.Plugin
 * @subpackage  Content.JoomlabGallery
 *
 * @copyright   (C) 2025 Alexandr Novikov. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace joomLab\Plugin\Content\JoomlabGallery\Extension;

defined('_JEXEC') or die;

use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Event\SubscriberInterface;
use Joomla\Event\Event;
use Joomla\CMS\Event\Model\PrepareDataEvent;
use Joomla\CMS\Event\Model\PrepareFormEvent;
use Joomla\CMS\Event\Model\BeforeSaveEvent;
use Joomla\CMS\Event\Content\ContentPrepareEvent;
use Joomla\CMS\Factory;
use Joomla\CMS\Filter\OutputFilter;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\Registry\Registry;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\Filesystem\File;
use Joomla\CMS\Filesystem\Folder;
use Joomla\CMS\Filesystem\Path;
use Joomla\CMS\Image\Image;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Language\Text;

class JoomlabGallery extends CMSPlugin implements SubscriberInterface
{
	protected $autoloadLanguage = true;

	public static function getSubscribedEvents(): array
	{
		return [
			'onContentPrepareData' => 'onContentPrepareData',
			'onContentPrepareForm' => 'onContentPrepareForm',
			'onContentPrepare' => 'onContentPrepare',
			'onContentBeforeSave' => 'onContentBeforeSave',
			'onAjaxJoomlabGallery' => 'onAjaxJoomlabGallery'
		];
	}

	public function onContentPrepareData(PrepareDataEvent $event) {
		$context = $event->getContext();
		if (!in_array($context, ['com_content.article'])) return;

		$data = $event->getData();

		// всегда работаем с объектом
		if (is_array($data)) {
			$dataObject = (object) $data;
			$item_id = isset($data['id']) ? $data['id'] : 0;
		} else {
			$dataObject = $data;
			$item_id = isset($data->id) ? $data->id : 0;
		}

		if (empty($item_id)) return;

		$db = Factory::getContainer()->get('DatabaseDriver');
		$query = $db->getQuery(true);
		$query->select('*')
			->from($db->quoteName('#__joomlab_gallery'))
			->where($db->quoteName('item_id') . ' = ' . (int)$item_id)
			->where($db->quoteName('context') . ' = ' . $db->quote($context));
		$db->setQuery($query);
		$galleries = $db->loadObjectList();

		if (!empty($galleries)) {
			if (!isset($dataObject->galleries)) {
				$dataObject->galleries = new \stdClass();
			}
			foreach ($galleries as $row => $field) {
				$r = 'galleries' . $row;
				$params = json_decode($field->params);
				$my_galleries = json_decode($field->galleries);
				$dataObject->galleries->{$r}['gallery']['id_gallery'] = (int)$field->id;
				$dataObject->galleries->{$r}['gallery']['item_id'] = (int)$field->item_id;
				$dataObject->galleries->{$r}['gallery']['gallery_name'] = $field->name;
				$dataObject->galleries->{$r}['gallery']['gallery_alias'] = $field->alias;
				$dataObject->galleries->{$r}['gallery']['resize'] = $params->resize ?? '';
				$dataObject->galleries->{$r}['gallery']['number'] = $params->number ?? '';
				$dataObject->galleries->{$r}['gallery']['maket'] = $params->maket ?? '';
				$dataObject->galleries->{$r}['gallery']['check_desc'] = (int)($params->check_desc ?? 0);
				$dataObject->galleries->{$r}['gallery']['arrows'] = (int)($params->arrows ?? 0);
				$dataObject->galleries->{$r}['gallery']['pagination'] = (int)($params->pagination ?? 0);
				$dataObject->galleries->{$r}['gallery']['type_pagination'] = $params->type_pagination ?? 'standart';
				$dataObject->galleries->{$r}['gallery']['loop'] = $params->loop ?? false;
				$dataObject->galleries->{$r}['gallery']['autoplay'] = (int)($params->autoplay ?? 0);
				$dataObject->galleries->{$r}['gallery']['time_autoplay'] = (int)($params->time_autoplay ?? 0);
				$dataObject->galleries->{$r}['gallery']['position'] = $params->position ?? '';
				$dataObject->galleries->{$r}['gallery']['fancy_thumb'] = (int)($params->fancy_thumb ?? 0);
				$dataObject->galleries->{$r}['gallery']['fancy_counter'] = (int)($params->fancy_counter ?? 0);
				$dataObject->galleries->{$r}['gallery']['fancy_download'] = (int)($params->fancy_counter ?? 0);
				$dataObject->galleries->{$r}['gallery']['my_gallery'] = $my_galleries;
			}
			// Обновляем данные
			if (is_array($data)) {
				// Если был массив
				$updatedData = (array) $dataObject;
				$event->setData($updatedData);
			} else {
				// Если был объект
				foreach (get_object_vars($dataObject) as $key => $value) {
					$data->$key = $value;
				}
			}
		}
	}

	public function onContentPrepareForm(PrepareFormEvent $event)
	{
		$form = $event->getForm();
		$context = $form->getName();
		if (!in_array($context, ['com_content.article'])) return;

		$this->loadLanguage();
		$doc = Factory::getDocument();
		$doc->addScriptDeclaration("
            document.addEventListener('DOMContentLoaded', function() {
                var form = document.getElementById('item-form') || document.getElementById('adminForm');
                if (form) {
                    form.setAttribute('enctype', 'multipart/form-data');
                }
            });
        ");

		$form->load('
            <form>
                <fieldset name="default" class="joomlab_gallery_admin_form">
                    <field 
                        name="galleries"
                        type="subform"    
                        multiple="true"
                        parentclass="stack"
                    >
                        <form>
                            <field
                                name="gallery"
                                type="gallery"
                                addfieldprefix="joomLab\Plugin\Content\JoomlabGallery\Fields"
                                label="PLG_CONTENT_JOOMLAB_GALLERY_LABEL"
                                required="false"
                            />
                        </form> 
                    </field>
                </fieldset>
            </form>', true);
	}

	public function onContentBeforeSave(BeforeSaveEvent $event) {
		$context = $event->getContext();
		if (!\in_array($context, ['com_content.article'])) return;

		$item = $event->getItem();
		$item_id = $item->id ?? 0;
		$app = $this->getApplication();

		//получаем галереи изформы
		$input = $app->getInput();
		$jformData = $input->get('jform', [], 'array');
		$galleries = $jformData['galleries'] ?? [];
		$db = Factory::getContainer()->get('DatabaseDriver');
		$media_param   = ComponentHelper::getParams('com_media', true);
		$plugin = PluginHelper::getPlugin('content', 'joomlab_gallery');
		$params = new Registry($plugin->params);
		$path_img = $params->get('path');
		//проверяем сколько было галерей
		$query = $db->getQuery(true);
		$query->select('*')
			->from($db->quoteName('#__joomlab_gallery'))
			->where($db->quoteName('item_id') . ' = ' . (int) $item_id);
		$db->setQuery($query);
		$old_galleries = $db->loadAssocList();

		if(empty($galleries) and empty($old_galleries)) return;
		if(!empty($galleries))
		{
			//удаляем убранныегалереи
			if (count($galleries) < count($old_galleries))
			{
				//удаляем галереи
				$old    = array_column($old_galleries, 'alias');
				$new    = array_column(array_column($galleries, 'gallery'), 'gallery_alias');
				$delete = array_diff($old, $new);
				//определяем id
				$query = $db->getQuery(true);
				$query->select('id')
					->from($db->quoteName('#__joomlab_gallery'))
					->where($db->quoteName('alias') . ' IN (' . implode(',', array_map([$db, 'quote'], $delete)) . ')');
				$db->setQuery($query);
				$delete_ids = $db->loadAssocList();
				foreach ($delete_ids as $delete_id)
				{

					//удаляем фото
					if (Folder::exists(JPATH_ROOT . '/' . $path_img . '/' . $item_id . '/' . $delete_id['id']))
					{
						Folder::delete(JPATH_ROOT . '/' . $path_img . '/' . $item_id . '/' . $delete_id['id']);
					}
					//удаляем из базы
					$query = $db->getQuery(true);
					$query->delete($db->quoteName('#__joomlab_gallery'))
						->where($db->quoteName('id') . ' = ' . (int) $delete_id['id']);
					$db->setQuery($query);
					$result = $db->execute();
				}
			}
		} else {
			//удаляем все галереи у материала
			//удаляем фото
			if (Folder::exists(JPATH_ROOT . '/' . $path_img . '/' . $item_id ))
			{
				Folder::delete(JPATH_ROOT . '/' . $path_img . '/' . $item_id);
			}
			//удаляем из базы
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__joomlab_gallery'))
				->where($db->quoteName('item_id') . ' = ' . (int) $item_id);
			$db->setQuery($query);
			$result = $db->execute();
		}

		$files = $input->files;
		// Обходим массив галерей
		foreach ($galleries as $main_key => $gallery) {
			try {
				$alias = '';
				$old_alias = '';
				$array_files = [];
				$array_gallery = [];
				if (!empty($files->get('jform', [], 'array')['galleries'][$main_key]['gallery']['photos']['files'])) {
					$array_files = $files->get('jform', [], 'array')['galleries'][$main_key]['gallery']['photos']['files'];
				}
				$array_gallery = $gallery['gallery'] ?? [];
				// Проверяем обязательные поля
				if (empty($array_gallery['gallery_name'])) {
					$app->enqueueMessage(Text::_('PLG_CONTENT_JOOMLAB_GALLERY_NAME_REQUIRED'), 'error');
					return false;
				}
				$isNew = empty($array_gallery['gallery_alias']);
				$alias = OutputFilter::stringURLSafe($array_gallery['gallery_name']);
				$old_alias = $array_gallery['gallery_alias'] ?? '';
				$params = [
					'resize' => $array_gallery['resize'] ?? '',
					'number' => $array_gallery['number'] ?? '',
					'maket' => $array_gallery['maket'] ?? '',
					'arrows' => $array_gallery['arrows'] ?? 0,
					'check_desc' => $array_gallery['check_desc'] ?? 0,
					'pagination' => $array_gallery['pagination'] ?? 0,
					'type_pagination' => $array_gallery['type_pagination'] ?? 0,
					'loop' => $array_gallery['loop'] ?? false,
					'autoplay' => $array_gallery['autoplay'] ?? 0,
					'time_autoplay' => $array_gallery['time_autoplay'] ?? 3000,
					'fancy_thumb' => $array_gallery['fancy_thumb'] ?? 0,
					'fancy_counter' => $array_gallery['fancy_counter'] ?? 0,
					'fancy_download' => $array_gallery['fancy_download'] ?? 0,
					'position' => $array_gallery['position'] ?? ''
				];
				// Проверяем есть ли что-то в галерее
				$query = $db->getQuery(true);
				$query->select('galleries')
					->from($db->quoteName('#__joomlab_gallery'))
					->where($db->quoteName('alias') . ' = ' . $db->quote($old_alias))
					->where($db->quoteName('item_id') . ' = ' . (int) $item_id);
				$db->setQuery($query);
				$list_files = $db->loadResult();

				if (!empty($list_files)) {
					$list_files = json_decode($list_files, true);
				}

				$my_galleries = new \stdClass();
				if (!empty($list_files)) {
					// Если в галерее есть файлы
					$index = 0;
					$descriptions = $array_gallery['description'] ?? [];
					foreach ($descriptions as $key => $description) {
						if ($key < count($list_files)) {
							// Берем имя файла из уже загруженных
							$my_galleries->{$index} = [
								'name' => $list_files[$key]['name'] ?? '',
								'description' => $description ?? ''
							];
						} else {
							// Берем имя файла из новых
							$file_name = $array_files[$key]['name'] ?? '';
							$file_name = File::makeSafe($file_name);
							$file_name = str_replace(' ', '-', $file_name);
							$my_galleries->{$index} = [
								'name' => $file_name,
								'description' => $description
							];
						}
						$index++;
					}
				} else {
					// Если галерея новая
					$index = 0;
					$descriptions = $array_gallery['description'] ?? [];
					foreach ($array_files as $key => $db_file) {
						foreach ($descriptions as $key_desc => $description) {
							if ($key == $key_desc) {
								$file_name = $array_files[$key]['name'] ?? '';
								$file_name = File::makeSafe($file_name);
								$file_name = str_replace(' ', '-', $file_name);
								$my_galleries->{$index} = [
									'name' => $file_name,
									'description' => $description
								];
								$index++;
							}
						}
					}
				}

				$g = new \stdClass();
				$g->item_id = $item_id;
				$g->name = $array_gallery['gallery_name'];
				$g->alias = $alias;
				$g->params = json_encode($params);
				$g->galleries = json_encode($my_galleries);
				$g->context = $context;

				if ($isNew) {
					// Если галерея новая, то проверяем и добавляем
					$query = $db->getQuery(true);
					$query->select('id')
						->from($db->quoteName('#__joomlab_gallery'))
						->where($db->quoteName('alias') . ' = ' . $db->quote($alias))
						->where($db->quoteName('item_id') . ' = ' . (int) $item_id);
					$db->setQuery($query);
					$id_gallery = $db->loadResult();
					// Если не добавлены файлы
					if (empty($files->get('jform', [], 'array')['galleries'][$main_key]['gallery']['photos']['files'])) {
						$app->enqueueMessage(Text::_('PLG_CONTENT_JOOMLAB_GALLERY_NO_PHOTO') . ' <strong>' . $array_gallery['gallery_name'] . '</strong>', 'error');
						return false;
					}
					// Проверяем, нет ли такого же алиаса
					if (!empty($id_gallery)) {
						// Если такая галерея уже есть, останавливаемся
						$app->enqueueMessage(Text::_('PLG_CONTENT_JOOMLAB_GALLERY_GALLERY') . ' <strong>' . $array_gallery['gallery_name'] . '</strong> '.Text::_('PLG_CONTENT_JOOMLAB_GALLERY_GALLERY_EST'), 'error');
						return false;
					} else {
						// Если такой галереи нет, сохраняем
						$result = $db->insertObject('#__joomlab_gallery', $g);
						$id_gallery = $db->insertid();
					}
				} else {
					//проверяем нет ли такого же алиаса
					if($alias != $old_alias)
					{
						$query = $db->getQuery(true);
						$query->select($db->quote('COUNT(id)', false))
							->from($db->quoteName('#__joomlab_gallery'))
							->where($db->quoteName('alias') . ' = ' . $db->quote($alias))
							->where($db->quoteName('item_id') . ' = ' . (int) $item_id);
						$db->setQuery($query);
						$count_alias = $db->loadResult();
						if ($count_alias > 0)
						{ //если такой же алиас, останавливаемся
							$app->enqueueMessage(Text::_('PLG_CONTENT_JOOMLAB_GALLERY_GALLERY') . ' <strong>' . $array_gallery['gallery_name'] . '</strong> ' . Text::_('PLG_CONTENT_JOOMLAB_GALLERY_GALLERY_EST'), 'error');
							return false;
						}
					}
					// Если алиас не пустой обновляем данные
					$query = $db->getQuery(true);
					$query->select('id')
						->from($db->quoteName('#__joomlab_gallery'))
						->where($db->quoteName('alias') . ' = ' . $db->quote($old_alias))
						->where($db->quoteName('item_id') . ' = ' . (int) $item_id);
					$db->setQuery($query);
					$id_gallery = $db->loadResult();

					$g->id = $id_gallery;
					$result = $db->updateObject('#__joomlab_gallery', $g, 'id');
				}
			} catch (\Exception $e) {
				$app->enqueueMessage($e->getMessage(), 'error');
				return false;
			}

			if(!empty($array_files))
			{
				foreach ($array_files as $file)
				{
					//загружаем файлы
					$filename = File::makeSafe($file['name']);
					$filename = str_replace(' ', '-', $filename);
					$size     = $file['size'];
					//проверяем размер
					$sizeOk = true;
					if ($size > $media_param->get('upload_maxsize') * 1048576) {
						$sizeOk = false;
					}
					//проверяем расширение
					$uploadedFileNameParts = explode('.', $filename);
					$uploadedFileExtension = array_pop($uploadedFileNameParts);
					$validFileExts         = explode(',', $media_param->get('image_extensions'));
					$extOk                 = false;
					foreach ($validFileExts as $key => $value) {
						if (preg_match("/$value/i", $uploadedFileExtension)) {
							$extOk = true;
							break;
						}
					}
					//проверяем тип файла
					$uploadedFileMimeType = $file['type'];
					$validMimeTypes       = explode(',', $media_param->get('upload_mime'));
					$mimeOk               = false;
					foreach ($validMimeTypes as $key => $value) {
						$escapedValue = preg_quote($value, '/');
						if (preg_match("/$escapedValue/i", $uploadedFileMimeType)) {
							$mimeOk = true;
							break;
						}
					}
					$src  = $file['tmp_name'];
					$desc = JPATH_ROOT . '/' . $path_img . '/' . $item_id . '/' . $id_gallery . '/' . $filename;
					//создаем путь
					if (!Folder::exists(JPATH_ROOT . '/' . $path_img . '/' . $item_id . '/' . $id_gallery . '/mini')) {
						Folder::create(JPATH_ROOT . '/' . $path_img . '/' . $item_id . '/' . $id_gallery . '/mini');
					}
					if (File::upload($src, $desc)) {
						$imagePath = $desc;
						$image     = new Image($imagePath);
						$size_mini = explode('/', $array_gallery['resize']);
						$newWidth  = $size_mini[0];
						$newHeight = $size_mini[1];
						$image->cropResize($newWidth, $newHeight, false);
						$image->toFile(JPATH_ROOT . '/' . $path_img . '/' . $item_id . '/' . $id_gallery . '/mini/' . $filename);
					} else {
						$app->enqueueMessage('<strong>' . $filename . '</strong> ' .Text::_('PLG_CONTENT_JOOMLAB_GALLERY_FILE_NOT_UPLOAD'), 'error');

						return false;
					}
				}
			}

			if (!empty($list_files)) {
				// пересохраняем миниатюры
				foreach ($list_files as $key => $list_file) {
					$filename  = $list_file['name'];
					$desc = JPATH_ROOT .'/'. $path_img . '/' . $item_id . '/'.$id_gallery.'/'. $filename;
					if(Path::check($desc)) {
						$imagePath = $desc;
						$image     = new Image($imagePath);
						$size_mini = explode('/', $array_gallery['resize']);
						$newWidth  = $size_mini[0];
						$newHeight = $size_mini[1];
						$image->cropResize($newWidth, $newHeight, false);
						$image->toFile(JPATH_ROOT . '/' . $path_img . '/' . $item_id . '/' . $id_gallery . '/mini/' . $filename);
					}
				}
			}
		}
		return true;
	}
	public function onAjaxJoomlabGallery(Event $event) {
		$app = $this->getApplication();
		$item_id = $app->getInput()->getInt('item_id');
		$task = $app->getInput()->getString('task');
		$context = $app->getInput()->getString('context');
		$db      = Factory::getContainer()->get('DatabaseDriver');
		$query   = $db->getQuery(true);
		$query->select('*')
			->from($db->quoteName('#__joomlab_gallery'))
			->where($db->quoteName('item_id') . ' = ' . (int) $item_id)
			->where($db->quoteName('context') . ' = ' . $db->quote($context));
		$db->setQuery($query);
		$list = $db->loadObjectList();
		$html = LayoutHelper::render('plugins.content.joomlab_gallery.modal.galleries', ['list' => $list, 'item_id' => $item_id]);
		$event->addResult($html);
	}
	public function onContentPrepare(ContentPrepareEvent $event) {
		$item = $event->getItem();
		$context = $event->getContext();
		$db = Factory::getContainer()->get('DatabaseDriver');
		if (strpos($item->text, '{gallery') === false) {
			return;
		}
		$result = preg_replace_callback('/\{gallery\s+(\d+)\}/', function($matches) use ($context, $db){
			$galleryId = $matches[1];
			$query = $db->getQuery(true);
			$query->select('*')
				->from($db->quoteName('#__joomlab_gallery'))
				->where($db->quoteName('id') . ' = ' . (int)$galleryId)
				->where($db->quoteName('context') . ' = ' . $db->quote($context));
			$db->setQuery($query);
			if($db->loadObjectList())
			{
				$gallery = $db->loadObjectList()[0];
				$maket   = json_decode($gallery->params)->maket;
				$html    = LayoutHelper::render('plugins.content.joomlab_gallery.' . $maket, ['gallery' => $gallery]);
			} else {
				$html = ''; // галерея не найдена
			}
			return $html;
		}, $item->text);

		$item->text = $result;
	}
}