<?php
/**
 * @package     joomLab.Plugin
 * @subpackage  Editors-xtd.ButtonGallery
 *
 * @copyright   (C) 2025 Alexandr Novikov. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

\defined('_JEXEC') or die;

use Joomla\CMS\Extension\PluginInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;
use Joomla\Event\DispatcherInterface;
use joomLab\Plugin\EditorsXtd\ButtonGallery\Extension\ButtonGallery;

return new class () implements ServiceProviderInterface {
	public function register(Container $container)
	{
		$container->set(
			PluginInterface::class,
			function (Container $container) {
				$plugin     = new ButtonGallery(
					$container->get(DispatcherInterface::class),
					(array) PluginHelper::getPlugin('editors-xtd', 'button_gallery')
				);
				$plugin->setApplication(Factory::getApplication());

				return $plugin;
			}
		);
	}
};