<?php
/**
 * @package     joomLab.Plugin
 * @subpackage  Editors-xtd.ButtonGallery
 *
 * @copyright   (C) 2025 Alexandr Novikov. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace joomLab\Plugin\EditorsXtd\ButtonGallery\Extension;

defined('_JEXEC') or die;

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Editor\Button\Button;
use Joomla\CMS\Event\Editor\EditorButtonsSetupEvent;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Session\Session;
use Joomla\Event\SubscriberInterface;

class ButtonGallery extends CMSPlugin implements SubscriberInterface
{
    protected $autoloadLanguage = true;
    public static function getSubscribedEvents(): array
    {
        return [
	        'onEditorButtonsSetup' => 'onEditorButtonsSetup'
        ];
    }
	public function onEditorButtonsSetup(EditorButtonsSetupEvent $event): void
	{
		$subject  = $event->getButtonsRegistry();
		$disabled = $event->getDisabledButtons();

		if (\in_array($this->_name, $disabled)) {
			return;
		}

		$button = $this->onDisplay($event->getEditorId());

		if ($button) {
			$subject->add($button);
		}
	}
	public function onDisplay($name)
	{
		$this->loadLanguage();
		// Guess the field context based on view.
		$jinput  = $this->getApplication()->getInput();
		$context = $jinput->get('option') . '.' . $jinput->get('view');
		if (!\in_array($context, ['com_content.article'])) return;
		$item_id = $jinput->get('id');

		// Special context for com_categories
		if ($context === 'com_categories.category') {
			$context = $jinput->get('extension', 'com_content') . '.categories';
		}

		$link = '../index.php?option=com_ajax&plugin=JoomlabGallery&format=html&group=content&task=ListGallery&item_id='.$item_id.'&layout=modal&tmpl=component&context='
			. $context . '&editor=' . $name . '&' . Session::getFormToken() . '=1';

		$button = new Button(
			$this->_name,
			[
				'action'  => 'modal',
				'link'    => $link,
				'text'    => Text::_('Галерея'),
				'icon'    => 'image',
				'iconSVG' => '<svg width="24" height="24" viewBox="0 0 512 512" focusable="false"><path d="M464 64H48C21.49 64 0 85.49 0 112v288c0 26.51 21.49 48 48 48h416c26.51 0 48-21.49 48-48V112c0-26.51-21.49-48-48-48zm-6 336H54a6 6 0 0 1-6-6V118a6 6 0 0 1 6-6h404a6 6 0 0 1 6 6v276a6 6 0 0 1-6 6zM128 152c-22.091 0-40 17.909-40 40s17.909 40 40 40 40-17.909 40-40-17.909-40-40-40zM96 352h320v-80l-87.515-87.515c-4.686-4.686-12.284-4.686-16.971 0L192 304l-39.515-39.515c-4.686-4.686-12.284-4.686-16.971 0L96 304v48z"></path></svg>',
				'name' => $this->_type . '_' . $this->_name,
			]
		);
		return $button;
	}
}