<?php
/**
 * @package     joomLab\Module\joomLabCalculator
 *
 * @copyright   Copyright (C) 2025 Alexandr Novikov. All rights reserved.
 * @license     GNU General Public License version 3 or later;
 */

defined('_JEXEC') or die;

use Joomla\CMS\Extension\Service\Provider\HelperFactory;
use Joomla\CMS\Extension\Service\Provider\Module;
use Joomla\CMS\Extension\Service\Provider\ModuleDispatcherFactory;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;

return new class() implements ServiceProviderInterface
{
    public function register(Container $container): void
    {
        $container->registerServiceProvider(new ModuleDispatcherFactory('\joomLab\Module\JoomlabCalculator'));
        $container->registerServiceProvider(new HelperFactory('\joomLab\Module\JoomlabCalculator\Site\Helper'));
        $container->registerServiceProvider(new Module());
    }
};