<?php

use Joomla\CMS\Factory;
use Joomla\Filesystem\File;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\Registry\Registry;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Image\Image;

define('_JEXEC', 1);
define('JPATH_BASE',$_SERVER['DOCUMENT_ROOT']);

require_once JPATH_BASE . '/includes/defines.php';
require_once JPATH_BASE . '/includes/framework.php';

$container = \Joomla\CMS\Factory::getContainer();
$container->alias(\Joomla\Session\SessionInterface::class, 'session.web.site');
$app = $container->get(\Joomla\CMS\Application\SiteApplication::class);
\Joomla\CMS\Factory::$application = $app;
$app->createExtensionNamespaceMap();

Session::checkToken('get') or die('no_t');

$plugin = PluginHelper::getPlugin('editors','editorjs');
$params = new Registry($plugin->params);
$ext_attach = $params->get('ext_attach');
$size_attach = $params->get('size_attach') * 1024 * 1024;


$uri = Uri::getInstance();
$domen = $uri->getHost();

$user = Factory::getUser();
$user_id = $user->id;

$input = Factory::getApplication()->input;
//$file = $input->files->get('file');
$file = $_FILES['file'];
$user_id = $input->get('user_id', '', 'int');

if(!$user_id) {
	return;
}
?>

<?php
$filename = $lang->transliterate($file['name']);//транслитерация
$filename = str_replace(' ', '_', $filename);//убираем пробелы
	$fileSize = $file['size'];
	$uploadedFileNameParts = explode('.',$filename);
	$uploadedFileExtension = array_pop($uploadedFileNameParts);
	$validFileExts = explode(',', $ext_attach);
	$extOk = false;
	foreach($validFileExts as $key => $value){
		if( preg_match("/$value/i", $uploadedFileExtension ) ){
			$extOk = true;
		}
	}
	if ($extOk == false || !$validFileExts) {
		echo 'no_valid_attach';
		return;
	}
	else if ( $fileSize > $size_attach ){
	echo 'no_size_attach';
		return;
	}

	$src = $file['tmp_name'];
	//создаем директории
	$dir = JPATH_BASE . '/images/editor/attach/' .$user_id;
	if (!is_dir($dir)) {
		mkdir($dir, 0777, true); 
	}
	$dest = JPATH_BASE . '/images/editor/attach/' .$user_id. '/' .$filename;
	$output = array();
	if(File::upload($src, $dest)) {
		//передаем массив
		$output["success"] = 1;
		$output["file"]["url"] = 'https://'.$domen.'/images/editor/attach/' .$user_id .'/' .$filename;
		$output["file"]["name"] = $filename;
		$output["file"]["title"] = $filename;
		$output["file"]["size"] = $fileSize;
		$output["file"]["extension"] = File::getExt($filename);
		print json_encode($output);
	}

