<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  YandexCaptcha
 *
 * @copyright   (C) 2024 Alexandr Novikov. <https://joomlab.ru>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Joomla\Plugin\Captcha\YandexCaptcha\Extension;

defined('_JEXEC') or die;

use Joomla\CMS\Event\Captcha\CaptchaSetupEvent;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Event\SubscriberInterface;
use Joomla\Http\HttpFactory;
use Joomla\Plugin\Captcha\YandexCaptcha\Provider\YandexCaptchaProvider;

final class YandexCaptcha extends CMSPlugin implements SubscriberInterface
{
    /**
     * Returns an array of events this plugin will listen to.
     *
     * @return  array
     */
    public static function getSubscribedEvents(): array
    {
        return [
            'onCaptchaSetup' => 'onCaptchaSetup',
        ];
    }
    
    /**
     * Register Captcha instance
     *
     * @param CaptchaSetupEvent $event
     *
     * @return void
     */
    public function onCaptchaSetup(CaptchaSetupEvent $event)
    {
       $event->getCaptchaRegistry()->add(new YandexCaptchaProvider($this->params, $this->getApplication(), $this->getDispatcher()));
    }
}