<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  YandexCaptcha
 *
 * @copyright   (C) 2024 Alexandr Novikov. <https://joomlab.ru>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Joomla\Plugin\Captcha\YandexCaptcha\Provider;


use Joomla\CMS\Application\CMSApplicationInterface;
use Joomla\CMS\Editor\AbstractEditorProvider;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Uri\Uri;
use Joomla\Event\DispatcherInterface;
use Joomla\Registry\Registry;
use Joomla\CMS\Captcha\CaptchaProviderInterface;
use Joomla\CMS\Form\FormField;

use Joomla\CMS\Http\HttpFactory;
use Joomla\CMS\Factory;

/**
 * Provider for Captcha
 */
final class YandexCaptchaProvider implements CaptchaProviderInterface
{
	protected $params;
	protected $application;
	//private $httpFactory;
	
    public function __construct(Registry $params, CMSApplicationInterface $application, DispatcherInterface $dispatcher)
    {
        $this->params      = $params;
        $this->application = $application;

    }
	
	
    /**
     * Return Captcha name, CMD string.
     *
     * @return string
     */
    public function getName(): string
    {
        return 'yandexcaptcha';
    }
    
    public function display($name = [], array $attributes = []): string
    {
		$key_client = $this->params->get('key_client', '');
		$displayData = [
			'key_client' => $key_client,
		];
       return LayoutHelper::render('captcha.yandexcaptcha.yandexcaptcha', $displayData, JPATH_PLUGINS . '/captcha/yandexcaptcha/layouts');
		
	}
    
    public function checkAnswer(string $code = null): bool  {
		foreach (['HTTP_CLIENT_IP',
				   'HTTP_X_FORWARDED_FOR',
				   'HTTP_X_FORWARDED',
				   'HTTP_FORWARDED_FOR',
				   'HTTP_FORWARDED',
				   'REMOTE_ADDR'] as $key)
		{
		  if (!empty($ipaddress = $this->application->getInput()->server->getString($key)))
		  {
			break;
		  }
		}

		$input = $this->application->input;
		$http = (new \Joomla\Http\HttpFactory)->getHttp([], ['curl', 'stream']);
		
		$args = [
		  'secret' => $this->params->get('key_server'),
		  'token' => $input->get('smart-token', '', 'string'),
		  'ip' => $ipaddress, 
		];

		$response = $http->post('https://smartcaptcha.yandexcloud.net/validate', $args, [], 10);
		if($response->code !== 200) {

		}
		$resp = json_decode($response->body);	
		if ($resp->status != 'ok'){
			return false;
		} else {
			return true;
		}				
	
    }
    
    /**
     * Method to react on the setup of a captcha field. Gives the possibility
     * to change the field and/or the XML element for the field.
     *
     * @param   FormField         $field    Captcha field instance
     * @param   \SimpleXMLElement  $element  XML form definition
     *
     * @return void
     *
     * @throws  \RuntimeException
     */
    public function setupField(FormField $field, \SimpleXMLElement $element): void
    {
        // Hide the label for this captcha type
        $element['hiddenLabel'] = 'true';
    }
}