<?php
/**
 * @package    WT JShopping cart save
 * @version       1.1.0
 * @Author        Sergey Tolkachyov, https://web-tolk.ru
 * @copyright     Copyright (C) 2024 Sergey Tolkachyov
 * @license       GNU/GPL http://www.gnu.org/licenses/gpl-3.0.html
 * @since         1.0.0
 */

namespace joomLab\Module\ContactMap\Site\Fields;

\defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\Field\NoteField;
use Joomla\CMS\Language\Text;

class ModuleinfoField extends NoteField
{

    protected $type = 'Moduleinfo';

    /**
     * Method to get the field input markup for a spacer.
     * The spacer does not have accept input.
     *
     * @return  string  The field input markup.
     *
     * @since   1.7.0
     */
    protected function getInput()
    {
        return ' ';
    }

    /**
     * @return  string  The field label markup.
     *
     * @since   1.7.0
     */
    protected function getLabel(): string
    {

        $module_info = simplexml_load_file(JPATH_SITE . "/modules/mod_contact_map/mod_contact_map.xml");

        return '</div>
		<div class="card container shadow-sm w-100 p-0">
			<div class="row" style="padding:10px">
				<div class="col-2 d-flex justify-content-center align-items-center">
				<a class="preloader_link" href="https://joomlab.ru" title="Расширения для CMS Joomla">
					<img style="width:150px;" src="https://joomlab.ru/images/logo_joomlab.png" alt="joomlab">
				</a>
				</div>
				<div class="col-10">
					<div class="card-header bg-white p-1">
						<span class="badge bg-success">v.' . $module_info->version . '</span>
					</div>
					<div style="padding:10px 5px">
						<a href="https://joomlab.ru/manual/contact-map" target="_blank">Документация</a>
					</div>
				</div>
			</div>
		</div><div>
		';
    }

    /**
     * Method to get the field title.
     *
     * @return  string  The field title.
     *
     * @since   1.7.0
     */
    protected function getTitle()
    {
        return $this->getLabel();
    }
}