<?php
defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Router\Route;
use Joomla\Component\Content\Site\Helper\RouteHelper;
use Joomla\Utilities\ArrayHelper;
use Joomla\CMS\Helper\ModuleHelper;
use Joomla\Registry\Registry;

//фильтруем поля, если выбраны в модуле
$module = ModuleHelper::getModule('favorite_list');
$params = new Registry($module->params);
$ids = $params->get('content_fields', '');
if(!empty($ids))
{
	$item['fields'] = array_filter($item['fields'], function ($field) use ($ids) {
		return in_array($field->id, $ids);
	});
} else {
	$item['fields'] = [];
}

$img = json_decode($item['article']->images)->image_intro;
$img_alt = json_decode($item['article']->images)->image_intro_alt;
$slug = $item['article']->id.':'.$item['article']->alias;
$link = Route::_(RouteHelper::getArticleRoute($slug, $item['article']->catid, $item['article']->language));
$fields =  ArrayHelper::pivot($item['fields'], 'name');
?>
<div class="item_favorite <?php if(empty($img)) {?>item_favorite_100<?php } ?>" data-item-id="<?php echo $item['article']->id ?>">
    <?php if(!empty($img)) { ?>
        <div class="favorite_img zoom-image">
            <a class="preloader_link" href="<?php echo $link ?>" title="<?php echo htmlspecialchars($item['article']->title) ?>">
                <?php echo HTMLHelper::image($img, $img_alt, ['loading' => 'lazy']); ?>
            </a>
        </div>
    <?php } ?>
    <div class="favorite_info">
        <div class="favorite_title">
            <a class="preloader_link" href="<?php echo $link ?>" title="<?php echo htmlspecialchars($item['article']->title) ?>">
				<?php echo $item['article']->title ?>
            </a>
        </div>
		<?php if(!empty($fields)) { ?>
			<?php foreach($fields as $name => $field) { ?>
                <div class="favorite_item_field <?php echo $name ?> <?php if($field->params->get('showlabel','', 'int') == 1) { ?>grid_favorite_field<?php } ?>">
					<?php if($field->params->get('showlabel','', 'int') == 1) { ?>
                        <label><?php echo $field->label ?></label>
					<?php } ?>
                    <span><?php echo $field->value ?></span>
                </div>
			<?php } ?>
		<?php } ?>
    </div>
    <div class="delete_item" data-item-id="<?php echo $item['article']->id ?>"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" tabindex="-1"><path d="M20 20L4 4m16 0L4 20"></path></svg></div>
</div>