<?php defined('_JEXEC') or die;
/**
 * @package     joomLab.Plugin
 * @subpackage  Content.Like
 *
 * @copyright   (C) 2025 Alexandr Novikov. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;

$wa = Factory::getApplication()->getDocument()->getWebAssetManager();
$wa->getRegistry()->addExtensionRegistryFile('plg_content_like');
$wa->useStyle('plg_content_like.css');
$wa->useScript('plg_content_like.js');

$all_likes = $param_like->get('likes');
$count_like = '';
?>
<div class="joomlike_block">
    <?php if($param_like->get('check_likes') == 1) {
            if(@$type_сounts['like']){
                $count_like = $type_сounts['like'];
            } else {
                $count_like = 0;
            }
        ?>
        <div class="all_likes">
            <div class="other_like" data-item-id="<?php echo $item->id ?>" data-type="like">
                <div>
                     <?php echo HTMLHelper::image($param_like->get('main_like_active'), '', ['loading'=>'lazy']); ?>
                     <span class="count_mini_like like"><?php echo $count_like; ?></span>
                </div>
            </div>
            <?php foreach($all_likes as $like) {
                if(@$type_сounts[$like->like_type]) {
                    $count_like = $type_сounts[$like->like_type];
                } else {
                    $count_like = 0;
                }
                ?>
                <div class="other_like" data-item-id="<?php echo $item->id ?>" data-type="<?php echo $like->like_type ?>">
                    <?php echo HTMLHelper::image($like->like_image, '', ['loading'=>'lazy']); ?>
                    <span class="count_mini_like <?php echo $like->like_type ?>"><?php echo $count_like ?></span>
                </div>
            <?php } ?>
        </div>
    <?php } ?>
    <div class="main_like <?php if($param_like->get('check_likes') == 1) { ?>multi_like<?php } else { ?>only_like<?php } ?>" data-item-id="<?php echo $item->id ?>" data-type="like">
        <?php echo HTMLHelper::image($like_img, '', ['loading'=>'lazy']); ?>
    </div>
    <div class="main_count_like"><?php echo $count_likes ?></div>
</div>
