<?php
/**
 * @package     joomLab.Plugin
 * @subpackage  Content.Like
 *
 * @copyright   (C) 2025 Alexandr Novikov. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace joomLab\Plugin\Content\Like\Extension;

defined('_JEXEC') or die;

use \Joomla\CMS\Event\Content\BeforeDisplayEvent;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Event\Event;
use Joomla\Event\SubscriberInterface;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Factory;
use Joomla\Registry\Registry;
use Joomla\Database\DatabaseInterface;
use Joomla\CMS\Environment\Browser;
use Joomla\CMS\Cache\Cache;
use stdClass;

class Like extends CMSPlugin implements SubscriberInterface
{

    protected $autoloadLanguage = true;

    public static function getSubscribedEvents(): array
    {
        return [
            'onContentBeforeDisplay' => 'onContentBeforeDisplay',
            'onAjaxLike' => 'onAjaxLike'
        ];
    }

    public function onContentBeforeDisplay(Event $event)
    {
        if($event->getContext() == 'com_content.article' or $event->getContext() == 'com_content.category' or $event->getContext() == 'com_content.featured') {
            $this->loadLanguage();
            $event->addResult($this->Like($event->getContext(), $event->getItem(), $event->getParams(), $event->getPage()));
        } else {
            return;
        }
    }

    public function Like($context, $item, $params, $limitstart = 0): string
    {
        $db = Factory::getContainer()->get(DatabaseInterface::class);
        $app = $this->getApplication();
        $user_id = $app->getIdentity()->id;
        $item_id = $item->id;
        $catid = $item->catid;
        $cookies = $app->input->cookie;
        $cookie = $cookies->get('item_like'.$item_id, '');

        $plugin = PluginHelper::getPlugin('content','like');
        $param_like = new Registry($plugin->params);
        $db = Factory::getContainer()->get(DatabaseInterface::class);

        if($param_like->get('catid', '')){
            if(!in_array($catid, $param_like->get('catid', ''))) {
                return false;
            }
        }

        //считаем лайки
        $db->setQuery("SELECT * FROM `#__joomlab_like` WHERE `item_id` = '{$item->id}'");
        $likes = $db->loadObjectList();
        $count_likes = count((array)$likes); //все лайки
        //лайки по типу
        $type_сounts = [];
        foreach ($likes as $item_like) {
            if (isset($item_like->type)) {
                if (isset($type_сounts[$item_like->type])) {
                    $type_сounts[$item_like->type]++;
                } else {
                    $type_сounts[$item_like->type] = 1;
                }
            }
        }
        //проверяем есть ли лайк пользователя
        if($user_id == 0) {
            $db->setQuery("SELECT * FROM `#__joomlab_like` WHERE `item_id` = '{$item_id}' AND `cookie` = '{$cookie}'");
        } else {
            $db->setQuery("SELECT * FROM `#__joomlab_like` WHERE `item_id` = '{$item_id}' AND (`user_id` = '{$user_id}' OR `cookie` = '{$cookie}')");
        }
        $count_my_likes = count((array)$db->loadObjectList());
        $type = @$db->loadObjectList()[0]->type;

        if($count_my_likes > 0) {
            $like_img = $param_like->get('main_like_active');
            if($type != 'like') {
                foreach ($param_like->get('likes') as $key => $value) {
                    if (isset($value->like_type) && $value->like_type === $type) {
                        $like_img = $value->like_image;
                        break; // Выходим из цикла, так как уже нашли нужный элемент
                    }
                }
            }
        } else {
            $like_img = $param_like->get('main_like');
        }

        $path = PluginHelper::getLayoutPath('content', 'like');
        ob_start();
        include $path;
        $html = ob_get_clean();
        return $html;
    }
    public function onAjaxLike(Event $event)
    {
        $plugin = PluginHelper::getPlugin('content','like');
        $param_like = new Registry($plugin->params);
        $db = Factory::getContainer()->get(DatabaseInterface::class);

        $app = $this->getApplication();
        $user_id = $app->getIdentity()->id;

        $input = $app->input;
        $item_id = $input->get('item_id','int');
        $task = $input->get('task','string');
        $type_click = $input->get('type','like','string');

        foreach (['HTTP_CLIENT_IP',
           'HTTP_X_FORWARDED_FOR',
           'HTTP_X_FORWARDED',
           'HTTP_FORWARDED_FOR',
           'HTTP_FORWARDED',
           'REMOTE_ADDR'] as $key)
        {
            if (!empty($ip = $app->getInput()->server->getString($key)))
            {
                break;
            }
        }
        $browser =  Browser::getInstance();
        $hash = md5($ip.':'.$browser->getAgentString());

        $cookies = $app->input->cookie;
        $cookie = $cookies->get('item_like'.$item_id, '');

        $context = 'com_content.article';

        //клик по лайку
        if($task == 'clickLike') {
            //проверяем есть ли лайк
            if($user_id == 0) {
                $db->setQuery("SELECT * FROM `#__joomlab_like` WHERE `item_id` = '{$item_id}' AND `cookie` = '{$cookie}'");
            } else {
                $db->setQuery("SELECT * FROM `#__joomlab_like` WHERE `item_id` = '{$item_id}' AND (`user_id` = '{$user_id}' OR `cookie` = '{$cookie}')");
            }
            $count_my_likes = count((array)@$db->loadObjectList());
            $type = @$db->loadObjectList()[0]->type;
            $id = @$db->loadObjectList()[0]->id;

            //если нет - добавляем
            if($count_my_likes == 0 and $cookie != $hash) {
                $cookies->set('item_like'.$item_id, $hash);
                $l = new stdClass();
                $l->id = $db->insertid();
                $l->context = $context;
                $l->user_id = $user_id;
                $l->item_id = $item_id;
                $l->type = $type_click;
                $l->cookie = $hash;
                $result = $db->insertObject('#__joomlab_like', $l);
            }
            //если есть - удаляем или меняем лайк
            if($count_my_likes > 0 or $cookie == $hash) {
                //если type одинаковые удаляем лайк
                if($type == $type_click or $type == null) {
                    $cookies->set('item_like'.$item_id, '');
                    if($user_id == 0) {
                        $db->setQuery("DELETE FROM `#__joomlab_like` WHERE `context` = '{$context}' AND `item_id` = '{$item_id}' AND `cookie` = '{$cookie}'");
                    } else {
                        $db->setQuery("DELETE FROM `#__joomlab_like` WHERE `context` = '{$context}' AND `item_id` = '{$item_id}' AND (`user_id` = '{$user_id}' OR `cookie` = '{$cookie}')");
                    }
                    $db->execute();
                    $no_image_like = true;
                } else { //если type разные, то меняем лайк
                    $updateNulls = true;
                    $l = new stdClass();
                    $l->id = $id;
                    $l->type = $type_click;
                    $result = $db->updateObject('#__joomlab_like', $l, 'id', $updateNulls);
                    //$event->addResult('plus');
                }
            }

            //пересчитываем лайки
            $db->setQuery("SELECT * FROM `#__joomlab_like` WHERE `item_id` = '{$item_id}'");
            $new_likes = $db->loadObjectList();
            $count_likes = count((array)$new_likes);
            $type_сounts = [];
            foreach ($new_likes as $item_like) {
                if (isset($item_like->type)) {
                    if (isset($type_сounts[$item_like->type])) {
                        $type_сounts[$item_like->type]++;
                    } else {
                        $type_сounts[$item_like->type] = 1;
                    }
                }
            }
            if($new_likes > 0) {
                $new_img = $param_like->get('main_like_active');
                if($type_click != 'like') {
                    foreach ($param_like->get('likes') as $key => $value) {
                        if (isset($value->like_type) && $value->like_type === $type_click) {
                            $new_img = $value->like_image;
                            break; // Выходим из цикла, так как уже нашли нужный элемент
                        }
                    }
                }
            }
            if(@$no_image_like == true) { //если нет своих лайков
                $new_img = $param_like->get('main_like');
            }

            //чистим кэш
            $cache = Cache::getInstance();
            $cache->clean('com_content');

            //массив с новыми значениями
            $new_count = json_encode(array('main_count' => $count_likes, 'type_count'=>$type_сounts, 'like_img'=>$new_img, 'item_id'=>$item_id));
            $event->addResult($new_count);
        }
    }
}