
<?php
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Filesystem\Folder;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\Registry\Registry;
use Joomla\CMS\Language\Text;

$plugin = PluginHelper::getPlugin('content', 'joomlab_gallery');
$params = new Registry($plugin->params);
$path_img = $params->get('path');

$wa = Factory::getApplication()->getDocument()->getWebAssetManager();
$wa->getRegistry()->addExtensionRegistryFile('plg_content_joomlab_gallery');
$wa->registerScript('joomlab_loader.js', 'media/system/js/joomla-core-loader.min.js');
$wa->useStyle('joomlab_gallery.admin.css');
$wa->useStyle('joomlab_gallery.swiper.css');
$wa->useScript('joomlab_gallery.swiper.js');
$wa->useScript('joomlab_gallery.admin.js');
$wa->useScript('joomlab_loader.js');

extract($displayData);
$val = (object)$value;
$id_gallery = @$val->id_gallery;
$item_id = @$val->item_id;
$gallery_name = @$val->gallery_name;
$gallery_alias = @$val->gallery_alias;
$resize = @$val->resize;
$number = @$val->number;
$checked_arrow = '';
if(@$val->arrows == 1) {
    $checked_arrow = 'checked';
}
$checked_desc = '';
if(@$val->check_desc == 1) {
	$checked_desc = 'checked';
}
$checked_pagination = '';
if(@$val->pagination == 1) {
	$checked_pagination = 'checked';
}
$checked_loop = '';
if(@$val->loop == 1) {
	$checked_loop = 'checked';
}
$checked_autoplay = '';
if(@$val->autoplay == 1) {
	$checked_autoplay = 'checked';
    $time_autoplay = @$val->time_autoplay;
}
$checked_thumb = '';
if(@$val->fancy_thumb == 1) {
	$checked_thumb = 'checked';
}
$checked_counter = '';
if(@$val->fancy_counter == 1) {
	$checked_counter = 'checked';
}
$checked_download = '';
if(@$val->fancy_download == 1) {
	$checked_download = 'checked';
}
$maket_value = @$val->maket;
$position = @$val->position;
$type_pagination = @$val->type_pagination;

$path = JPATH_ROOT . '/layouts/plugins/content/joomlab_gallery';
$filter = '\.(php)$';
$files = Folder::files($path, $filter, false, true);
$makets = [];
foreach($files as $file) {
    $makets[] = explode('.', basename($file))[0];
}
$my_galleries = @$val->my_gallery;

?>

<div class="row">
    <div class="controls">
        <label><?php echo Text::_('PLG_CONTENT_JOOMLAB_GALLERY_NAME_GALLERY') ?></label>
        <input
                type="text"
                name="<?php echo $name; ?>[gallery_name]"
                id="<?php echo $id; ?>__name"
                class="form-control"
                <?php if(!empty($gallery_name)) { ?>
                    value="<?php echo htmlspecialchars($gallery_name, ENT_COMPAT, 'UTF-8'); ?>"
                <?php  } else { ?>
                    value=""
                <?php } ?>
        />
    </div>
    <div class="controls">
        <div class="col-md-12">
        <label><?php echo Text::_('PLG_CONTENT_JOOMLAB_GALLERY_ALIAS_GALLERY') ?></label>
        <input
                type="text"
                name="<?php echo $name; ?>[gallery_alias]"
                id="<?php echo $id; ?>__alias"
                class="form-control"
                placeholder="<?php echo Text::_('PLG_CONTENT_JOOMLAB_GALLERY_ALIAS_AUTO') ?>"
                readonly
            <?php if(!empty($gallery_alias)) { ?>
                value="<?php echo $gallery_alias ?>"
            <?php  } ?>
        />
        </div>
    </div>
    <div class="controls">
        <div class="col-md-12">
        <label><?php echo Text::_('PLG_CONTENT_JOOMLAB_GALLERY_RESIZE_GALLERY') ?></label>
        <input
                type="text"
                name="<?php echo $name; ?>[resize]"
                id="<?php echo $id; ?>__resize"
                class="form-control"
                <?php if(!empty($resize)) { ?>
                    value="<?php echo $resize ?>"
                <?php }  else { ?>
                    value="150/150"
                <?php }?>
        />
        </div>
    </div>
    <div class="controls">
        <div class="col-md-12">
        <label><?php echo Text::_('PLG_CONTENT_JOOMLAB_GALLERY_NUMBER_GALLERY') ?></label>
        <input
                type="number"
                name="<?php echo $name; ?>[number]"
                id="<?php echo $id; ?>__number"
                class="form-control"
                <?php if(!empty($number)) { ?>
                    value="<?php echo $number ?>"
                <?php } else { ?>
                    value="4"
                <?php } ?>
        />
        </div>
    </div>
    <div class="controls">
        <div class="col-md-12">
        <label><?php echo Text::_('PLG_CONTENT_JOOMLAB_GALLERY_EFFECT_GALLERY') ?></label>
            <select name="<?php echo $name; ?>[maket]" class="form-select">
                <?php  foreach($makets as $maket) {
                    $selected = '';
                    if($maket == $maket_value) {
                        $selected = 'selected';
                    }
                    ?>
                    <option value="<?php echo $maket ?>" <?php echo $selected ?>><?php echo $maket ?></option>
                <?php } ?>
            </select>
        </div>
    </div>
</div>
<div class="grid_gallery row">
    <div class="control_s">
        <input type="file" id="file-<?php echo $id; ?>" name="<?php echo $name; ?>[photos]" multiple style="display: none;" />
        <div class="fixed-add-button">
            <button id="<?php echo $id; ?>" name="<?php echo $name; ?>[photos]" type="button" class="add-image-btn btn btn-primary w-100" title="Добавить изображения">
                <span class="icon-image"></span>
                <span class="add-text"><?php echo Text::_('PLG_CONTENT_JOOMLAB_GALLERY_ADD_PHOTO_GALLERY') ?></span>
            </button>
        </div>
    </div>
    <div class="controls">
        <button type="button" class="btn btn-warning w-100" data-bs-toggle="modal" data-bs-target="#setting_<?php echo $id; ?>">
            <span class="icon-cogs"></span>
            <span><?php echo Text::_('PLG_CONTENT_JOOMLAB_GALLERY_SETTING_GALLERY') ?></span>
        </button>
    </div>
    <div class="controls">

    </div>
    <div class="controls">
    </div>
    <div class="controls">
    </div>
</div>
<div class="controls gallery_block">
    <!-- Слайдер только для превью -->
    <div class="col-md-12">
        <div class="joomlab_gallary_admin swiper preview-swiper" id="swiper-<?php echo $id; ?>" name="swiper-<?php echo $id; ?>">
            <div class="swiper-wrapper">
                <?php if(!empty($my_galleries)) { ?>
                    <?php foreach($my_galleries as $index => $slide) { ?>
                        <div class="swiper-slide">
                            <div class="image-preview">
                                <img loading="lazy" src="/<?php echo $path_img ?>/<?php echo $item_id ?>/<?php echo $id_gallery ?>/mini/<?php echo $slide->name?>" alt="<?php echo $slide->name ?>" />
                                <button type="button" class="remove-image delete_img" data-id-gallery="<?php echo $id_gallery ?>" data-filename="<?php echo $slide->name?>" data-file-index="<?php echo $index ?>">×</button>
                            </div>
                        </div>
                    <?php } ?>
                <?php } ?>
            </div>
            <div class="swiper-button-next"></div>
            <div class="swiper-button-prev"></div>
       <!--<div class="swiper-pagination"></div>-->
        </div>
    </div>
    <div class="controls">
        <div class="switcher">
            <input type="radio" id="desc-<?php echo $id; ?>0" name="<?php echo $name; ?>[check_desc]" value="0" checked="" class="active ">
            <label for="desc-<?php echo $id; ?>0"><?php echo Text::_('PLG_CONTENT_JOOMLAB_GALLERY_OPEN_DESC_GALLERY') ?></label>
            <input type="radio" id="desc-<?php echo $id; ?>1" name="<?php echo $name; ?>[check_desc]" value="1" <?php echo $checked_desc ?> class="valid">
            <label for="desc-<?php echo $id; ?>1"><?php echo Text::_('PLG_CONTENT_JOOMLAB_GALLERY_CLOSE_DESC_GALLERY') ?></label>
            <span class="toggle-outside"><span class="toggle-inside"></span></span>
        </div>
    </div>
    <div class="thumbnails-container" id="thumbnails_<?php echo $id; ?>" name="thumbnails-<?php echo $name; ?>">
        <?php if(!empty($my_galleries)) { ?>
            <?php foreach($my_galleries as $index => $slide){?>
                <div class="thumbnail-block" data-slide-index="<?php echo $index?>" data-file-index="<?php echo $index?>" draggable="true">
                    <button type="button" class="group-slide btn btn-sm btn-primary" aria-label="Переместить" data-slide-index="0">
                        <span class="icon-arrows-alt icon-white" aria-hidden="true"></span>
                    </button>
                    <div class="thumbnail-preview">
                        <img loading="lazy" src="/<?php echo $path_img ?>/<?php echo $item_id ?>/<?php echo $id_gallery ?>/mini/<?php echo $slide->name?>" alt="<?php echo $slide->name ?>" />
                    </div>
                    <input type="text" class="form-control" name="<?php echo $name; ?>[description][<?php echo $index ?>]" id="<?php echo $id; ?>__description_<?php echo $index ?>" value="<?php echo $slide->description?>" placeholder="Описание" data-slide-index="<?php echo $index ?>" data-file-index="<?php echo $index ?>">
                    <button type="button" class="remove-thumbnail delete_img" data-id-gallery="<?php echo $id_gallery ?>" data-slide-index="<?php echo $index ?>" data-file-index="<?php echo $index ?>">×</button>
                </div>
            <?php } ?>
	    <?php } ?>
    </div>
</div>

<div class="modal fade joomlab_modal" id="setting_<?php echo $id; ?>" tabindex="-1" aria-labelledby="exampleModalLabel_<?php echo $id; ?>" aria-hidden="true" >
    <div class="modal-dialog joomla-dialog-container">
        <header class="joomla-dialog-header">
            <span aria-hidden="true" class="header-icon icon-cogs"></span>
            <h3><?php echo Text::_('PLG_CONTENT_JOOMLAB_GALLERY_SETTING_GALLERY') ?></h3>
            <div class="buttons-holder">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
        </header>
        <section class="joomla-dialog-body">
            <div class="contentpane controls">
                <div class="row">
                    <div class="col-sm-6">
                        <h4><?php echo Text::_('PLG_CONTENT_JOOMLAB_GALLERY_SETTING_SWIPER_GALLERY') ?></h4>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="control-group">
                                    <div class="controls">
                                        <div class="switcher">
                                            <input type="radio" id="arrows-<?php echo $id; ?>0" name="<?php echo $name; ?>[arrows]" value="0" checked="" class="active ">
                                            <label for="arrows-<?php echo $id; ?>0"><?php echo Text::_('PLG_CONTENT_JOOMLAB_GALLERY_SHOW_ARROWS') ?></label>
                                            <input type="radio" id="arrows-<?php echo $id; ?>1" name="<?php echo $name; ?>[arrows]" value="1" <?php echo $checked_arrow ?> >
                                            <label for="arrows-<?php echo $id; ?>1"><?php echo Text::_('PLG_CONTENT_JOOMLAB_GALLERY_HIDE_ARROWS') ?></label>
                                            <span class="toggle-outside"><span class="toggle-inside"></span></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="control-group">
                                    <div class="controls">
                                        <div class="switcher">
                                            <input type="radio" id="loop-<?php echo $id; ?>0" name="<?php echo $name; ?>[loop]" value="false" checked="">
                                            <label for="loop-<?php echo $id; ?>0"><?php echo Text::_('PLG_CONTENT_JOOMLAB_GALLERY_LOOP') ?></label>
                                            <input type="radio" id="loop-<?php echo $id; ?>1" name="<?php echo $name; ?>[loop]" value="true" <?php echo $checked_loop ?> class="valid">
                                            <label for="loop-<?php echo $id; ?>1"><?php echo Text::_('PLG_CONTENT_JOOMLAB_GALLERY_LOOP') ?></label>
                                            <span class="toggle-outside"><span class="toggle-inside"></span></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="control-group">
                                    <div class="controls">
                                        <div class="switcher">
                                            <input type="radio" id="pagination-<?php echo $id; ?>0" name="<?php echo $name; ?>[pagination]" value="0" checked="" class="active ">
                                            <label for="pagination-<?php echo $id; ?>0"><?php echo Text::_('PLG_CONTENT_JOOMLAB_GALLERY_SHOW_PAGINATION') ?></label>
                                            <input type="radio" id="pagination-<?php echo $id; ?>1" name="<?php echo $name; ?>[pagination]" value="1" <?php echo $checked_pagination ?> class="valid">
                                            <label for="pagination-<?php echo $id; ?>1"><?php echo Text::_('PLG_CONTENT_JOOMLAB_GALLERY_HIDE_PAGINATION') ?></label>
                                            <span class="toggle-outside"><span class="toggle-inside"></span></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="control-group">
                                    <div class="controls">
                                        <select name="<?php echo $name; ?>[type_pagination]" class="form-select">
                                            <option value="standart" <?php if($type_pagination == 'standart') { ?>selected<?php } ?>><?php echo Text::_('PLG_CONTENT_JOOMLAB_GALLERY_PAGINATION_STANDART') ?></option>
                                            <option value="dinamic" <?php if($type_pagination == 'dinamic') { ?>selected<?php } ?>><?php echo Text::_('PLG_CONTENT_JOOMLAB_GALLERY_PAGINATION_DYNAMIC') ?></option>
                                            <option value="progressbar" <?php if($type_pagination == 'progressbar') { ?>selected<?php } ?>><?php echo Text::_('PLG_CONTENT_JOOMLAB_GALLERY_PAGINATION_PROGRESS') ?></option>
                                            <option value="fraction" <?php if($type_pagination == 'fraction') { ?>selected<?php } ?>><?php echo Text::_('PLG_CONTENT_JOOMLAB_GALLERY_PAGINATION_FRACTION') ?></option>
                                            <option value="custom" <?php if($type_pagination == 'custom') { ?>selected<?php } ?>><?php echo Text::_('PLG_CONTENT_JOOMLAB_GALLERY_PAGINATION_CUSTOM') ?></option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="control-group">
                                    <div class="controls">
                                        <div class="switcher">
                                            <input type="radio" id="autoplay-<?php echo $id; ?>0" name="<?php echo $name; ?>[autoplay]" value="0" checked="" >
                                            <label for="autoplay-<?php echo $id; ?>0">Autoplay</label>
                                            <input type="radio" id="autoplay-<?php echo $id; ?>1" name="<?php echo $name; ?>[autoplay]" value="1" <?php echo $checked_autoplay ?>>
                                            <label for="autoplay-<?php echo $id; ?>1">Autoplay</label>
                                            <span class="toggle-outside"><span class="toggle-inside"></span></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="control-group">
                                    <div class="controls">
                                        <input
                                                type="number"
                                                name="<?php echo $name; ?>[time_autoplay]"
                                                id="<?php echo $id; ?>__time_autoplay"
                                                class="form-control"
		                                    <?php if(!empty($time_autoplay)) { ?>
                                                value="<?php echo $time_autoplay ?>"
		                                    <?php } else { ?>
                                                value="3000"
		                                    <?php } ?>
                                        />
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <select name="<?php echo $name; ?>[position]" class="form-select">
                                    <option value="w100" <?php if($position == 'w100') { ?>selected<?php } ?>><?php echo Text::_('PLG_CONTENT_JOOMLAB_GALLERY_W100') ?></option>
                                    <option value="text-right" <?php if($position == 'text-right') { ?>selected<?php } ?>><?php echo Text::_('PLG_CONTENT_JOOMLAB_GALLERY_TEXT_RIGHT') ?></option>
                                    <option value="text-left" <?php if($position == 'text-left') { ?>selected<?php } ?>><?php echo Text::_('PLG_CONTENT_JOOMLAB_GALLERY_TEXT_LEFT') ?></option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <h4><?php echo Text::_('PLG_CONTENT_JOOMLAB_GALLERY_SETTING_FANCYBOX') ?></h4>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="control-group">
                                    <div class="controls">
                                        <div class="switcher">
                                            <input type="radio" id="fancy-thumb-<?php echo $id; ?>0" name="<?php echo $name; ?>[fancy_thumb]" value="0" checked="" >
                                            <label for="fancy-thumb-<?php echo $id; ?>0"><?php echo Text::_('PLG_CONTENT_JOOMLAB_GALLERY_FANCYBOX_SHOW_MINIATURE') ?></label>
                                            <input type="radio" id="fancy-thumb-<?php echo $id; ?>1" name="<?php echo $name; ?>[fancy_thumb]" value="1" <?php echo $checked_thumb ?>>
                                            <label for="fancy-thumb-<?php echo $id; ?>1"><?php echo Text::_('PLG_CONTENT_JOOMLAB_GALLERY_FANCYBOX_HIDE_MINIATURE') ?></label>
                                            <span class="toggle-outside"><span class="toggle-inside"></span></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="control-group">
                                    <div class="controls">
                                        <div class="switcher">
                                            <input type="radio" id="fancy-counter-<?php echo $id; ?>0" name="<?php echo $name; ?>[fancy_counter]" value="0" checked="" >
                                            <label for="fancy-counter-<?php echo $id; ?>0"><?php echo Text::_('PLG_CONTENT_JOOMLAB_GALLERY_FANCYBOX_SHOW_COUNTER') ?></label>
                                            <input type="radio" id="fancy-counter-<?php echo $id; ?>1" name="<?php echo $name; ?>[fancy_counter]" value="1" <?php echo $checked_counter ?>>
                                            <label for="fancy-counter-<?php echo $id; ?>1"><?php echo Text::_('PLG_CONTENT_JOOMLAB_GALLERY_FANCYBOX_HIDE_COUNTER') ?></label>
                                            <span class="toggle-outside"><span class="toggle-inside"></span></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="control-group">
                                    <div class="controls">
                                        <div class="switcher">
                                            <input type="radio" id="fancy-download-<?php echo $id; ?>0" name="<?php echo $name; ?>[fancy_download]" value="0" checked="" >
                                            <label for="fancy-download-<?php echo $id; ?>0"><?php echo Text::_('PLG_CONTENT_JOOMLAB_GALLERY_FANCYBOX_SHOW_DOWNLOAD') ?></label>
                                            <input type="radio" id="fancy-download-<?php echo $id; ?>1" name="<?php echo $name; ?>[fancy_download]" value="1" <?php echo $checked_download ?>>
                                            <label for="fancy-download-<?php echo $id; ?>1"><?php echo Text::_('PLG_CONTENT_JOOMLAB_GALLERY_FANCYBOX_HIDE_DOWNLOAD') ?></label>
                                            <span class="toggle-outside"><span class="toggle-inside"></span></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <footer class="joomla-dialog-footer">
            <div class="buttons-holder">
                <button type="button" class="btn btn-primary" data-bs-dismiss="modal"><?php echo Text::_('PLG_CONTENT_JOOMLAB_GALLERY_CLOSE') ?></button>
            </div>
        </footer>
    </div>
</div>


