<?php
/**
 * @package     joomLab\Module\joomLabCalculator
 *
 * @copyright   Copyright (C) 2025 Alexandr Novikov. All rights reserved.
 * @license     GNU General Public License version 3 or later;
 */
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Filter\OutputFilter;

extract($displayData);

$app = Factory::getApplication();
$formData = $app->getInput();
$newFormData = [];
$newResult = [];
?>
<div id="calculator_form_<?php echo $module->id ?>">
    <h2><?php echo $module->title ?></h2>
    <div class="calculator_info_form">
        <?php foreach($form->get('calculators') as $calculator) { ?>
            <div>
                <div class="calculator_title_field_name"><?php echo $calculator->field_name ?></div>
                <?php if($calculator->field_type == 'select') {
	                $fieldName = OutputFilter::stringURLSafe($calculator->field_name).'_'.$module->id;
                    ?>
	                <?php if(is_array($formData->get($fieldName))) { ?>
		                <?php foreach($formData->get($fieldName) as $key => $select) { ?>
			                <?php foreach($calculator->radio as $radio) { ?>
				                <?php if($select == $radio->radio_value) {
					                $newFormData[$fieldName][] = ['name'=>$calculator->field_name, 'text'=> $radio->radio_name, 'value'=> $radio->radio_value, 'izmerenie'=> $calculator->izmerenie];
					                ?>
                                    <div>
                                        <strong><?php echo $radio->radio_name ?></strong>
                                        <span><?php echo $radio->radio_value ?> <?php echo $calculator->izmerenie ?></span>
                                    </div>
				                <?php } ?>
			                <?php } ?>
		                <?php } ?>
	                <?php } else { ?>
		                <?php foreach($calculator->radio as $radio) {
			                $fieldName = OutputFilter::stringURLSafe($calculator->field_name).'_'.$module->id;
			                ?>
                                <?php if($radio->radio_value) { ?>
                                    <?php if($formData->get($fieldName) == $radio->radio_value) {
                                        $newFormData[$fieldName] = ['name'=>$calculator->field_name, 'text'=> $radio->radio_name, 'value'=> $radio->radio_value, 'izmerenie'=> $calculator->izmerenie];
                                        ?>
                                        <div>
                                            <strong><?php echo $radio->radio_name ?></strong>
                                            <span><?php echo $radio->radio_value ?> <?php echo $calculator->izmerenie ?></span>
                                        </div>
                                    <?php } ?>
                                <?php } else { ?>
                                    <strong>Не выбрано</strong>
                                <?php } ?>
		                 <?php } ?>
                    <?php } ?>
                <?php } ?>
                <?php if($calculator->field_type == 'radio') { ?>
                    <?php foreach($calculator->radio as $radio) {
                        $fieldName = OutputFilter::stringURLSafe($calculator->field_name).'_'.$module->id;
                        ?>
                        <?php if($formData->get($fieldName) == $radio->radio_value) {
                            $newFormData[$fieldName] = ['name'=>$calculator->field_name, 'text'=> $radio->radio_name, 'value'=> $radio->radio_value, 'izmerenie'=> $calculator->izmerenie];
                            ?>
                                <div>
                                    <strong><?php echo $radio->radio_name ?></strong>
                                    <span><?php echo $radio->radio_value ?> <?php echo $calculator->izmerenie ?></span>
                                </div>
                        <?php } ?>
                    <?php } ?>
                <?php } ?>
                <?php if($calculator->field_type == 'number') {
                    $fieldName = OutputFilter::stringURLSafe($calculator->field_name).'_'.$module->id;
                    $newFormData[$fieldName] = ['name'=>$calculator->field_name, 'text'=> '', 'value'=> $formData->get($fieldName), 'izmerenie'=> $calculator->izmerenie];
                    ?>
                    <strong><?php echo $formData->get($fieldName) ?> <?php echo $calculator->izmerenie ?></strong>
                <?php } ?>
                <?php  if($calculator->field_type == 'checkbox') {
                    $fieldName = OutputFilter::stringURLSafe($calculator->field_name).'_'.$module->id;
                    ?>
                    <?php if(is_array($formData->get($fieldName))) { ?>
                        <?php foreach($formData->get($fieldName) as $key => $checkbox) { ?>
                            <?php foreach($calculator->radio as $radio) { ?>
                                <?php if($checkbox == $radio->radio_value) {
                                    $newFormData[$fieldName][] = ['name'=>$calculator->field_name, 'text'=> $radio->radio_name, 'value'=> $radio->radio_value, 'izmerenie'=> $calculator->izmerenie];
                                    ?>
                                        <div>
                                            <strong><?php echo $radio->radio_name ?></strong>
                                            <span><?php echo $radio->radio_value ?> <?php echo $calculator->izmerenie ?></span>
                                        </div>
                                <?php } ?>
                            <?php } ?>
                        <?php } ?>
                    <?php } else { ?>
                        <strong>Не выбрано</strong>
                    <?php } ?>
                <?php } ?>
            </div>
        <?php } ?>

    </div>
    <div class="calculator_form_result">
        <?php foreach($form->get('formuls') as $formula) { //показ результатов
            $newResult[OutputFilter::stringURLSafe($formula->peremennaya)] = ['name'=>$formula->peremennaya, 'value'=>$result[OutputFilter::stringURLSafe($formula->peremennaya)], 'izmerenie' => $formula->izmerenie]
        ?>
            <div><label><?php echo $formula->peremennaya ?></label> <strong><?php echo $result[OutputFilter::stringURLSafe($formula->peremennaya)] ?> <?php echo $formula->izmerenie ?></strong></div>
        <?php } ?>
    </div>
    <div id="calculator_form_send_<?php echo $module->id ?>" class="calculator_form_send">
        <?php foreach($form->get('form_mail') as $field) { ?>
            <div class="form-group">
                <input type="text" name="<?php echo OutputFilter::stringURLSafe($field->form_mail_field) ?>" class="form-control" placeholder="<?php echo $field->form_mail_field ?>" />
            </div>
        <?php } ?>
        <?php if($form->get('check_comment')) { ?>
            <div class="form-group">
                <textarea name="calculator_comment" class="form-control" placeholder="Введите текст комментария"></textarea>
            </div>
        <?php } ?>
        <div class="form-group">
            <input id="calculator_soglasie" name="calculator_soglasie" type="checkbox" class="form-check-input" />
            <label for="calculator_soglasie"><?php echo $form->get('form_soglasie_text') ?></label>
        </div>
        <div class="form-group">
            <div class="calculator_send_btn">
                <button id="send_form_<?php echo $module->id ?>" type="button" class="send_form btn btn-primary" data-calculator-id="<?php echo $module->id ?>">
                    <?php echo $form->get('send_btn') ?>
                </button>
            </div>
        </div>
        <input type="hidden" name="newFormData" value='<?php echo base64_encode(json_encode($newFormData)) ?>' />
        <input type="hidden" name="newResult" value='<?php echo base64_encode(json_encode($newResult)) ?>' />
    </div>
</div>