<?php
/**
 * @package     joomLab\Module\ContactMap
 *
 * @copyright   Copyright (C) 2025 Alexandr Novikov. All rights reserved.
 * @license     GNU General Public License version 2 or later;
 */
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\Filesystem\File;
use Joomla\Filesystem\Folder;
use Joomla\Filesystem\Path;
use Joomla\CMS\Installer\Installer;
use Joomla\CMS\Installer\InstallerAdapter;
use Joomla\CMS\Installer\InstallerScriptInterface;
use Joomla\CMS\Language\Text;

return new class () implements InstallerScriptInterface {

    private string $minimumJoomla = '5.0.0';
    private string $minimumPhp = '8.0.0';

    public function install(InstallerAdapter $adapter): bool
    {
        $module_info = simplexml_load_file(JPATH_SITE . "/modules/mod_joomlab_calculator/mod_joomlab_calculator.xml");

        echo '</div>
		<div class="card container shadow-sm w-100 p-0">
			<div class="row" style="padding:10px">
				<div class="col-2 d-flex justify-content-center align-items-center">
				<a class="preloader_link" href="https://joomlab.ru" title="Расширения для CMS Joomla">
					<img style="width:150px;" src="https://joomlab.ru/images/logo_joomlab.png" alt="joomlab">
				</a>
				</div>
				<div class="col-10">
					<div class="card-header bg-white p-1">
						<span class="badge bg-success">v.' . $module_info->version . '</span>
					</div>
					<div style="padding:10px 5px">
						Telegram <a href="https://t.me/pro_portal" target="_blank">@pro_portal</a>
					</div>
				</div>
			</div>
		</div><div>
		';
        return true;
    }

    public function update(InstallerAdapter $adapter): bool
    {

        $module_info = simplexml_load_file(JPATH_SITE . "/modules/mod_joomlab_calculator/mod_joomlab_calculator.xml");

        echo '</div>
		<div class="card container shadow-sm w-100 p-0">
			<div class="row" style="padding:10px">
				<div class="col-2 d-flex justify-content-center align-items-center">
				<a class="preloader_link" href="https://joomlab.ru" title="Расширения для CMS Joomla">
					<img style="width:150px;" src="https://joomlab.ru/images/logo_joomlab.png" alt="joomlab">
				</a>
				</div>
				<div class="col-10">
					<div class="card-header bg-white p-1">
						<span class="badge bg-success">v.' . $module_info->version . '</span>
					</div>
					<div style="padding:10px 5px">
						Telegram <a href="https://t.me/pro_portal" target="_blank">@pro_portal</a>
					</div>
				</div>
			</div>
		</div><div>
		';
        return true;
    }

    public function uninstall($parent): bool
    {
        $this->removeLayouts($parent->getParent()->getManifest()->layouts);
        //echo "mod_hello uninstall<br>";
        return true;
    }

    public function preflight(string $type, InstallerAdapter $adapter): bool
    {


        if (version_compare(PHP_VERSION, $this->minimumPhp, '<')) {
            Factory::getApplication()->enqueueMessage(sprintf(Text::_('JLIB_INSTALLER_MINIMUM_PHP'), $this->minimumPhp), 'error');
            return false;
        }

        if (version_compare(JVERSION, $this->minimumJoomla, '<')) {
            Factory::getApplication()->enqueueMessage(sprintf(Text::_('JLIB_INSTALLER_MINIMUM_JOOMLA'), $this->minimumJoomla), 'error');
            return false;
        }

        return true;
    }

    public function postflight($type, $parent): bool

    {
        $this->parseLayouts($parent->getParent()->getManifest()->layouts, $parent->getParent());

       // echo "mod_hello postflight<br>";
        return true;
    }

    public function parseLayouts(SimpleXMLElement $element = null, Installer $installer = null): bool
    {
        if (!$element || !count($element->children()))
        {
            return false;
        }

        // Get destination
        $folder      = ((string) $element->attributes()->destination) ? '/' . $element->attributes()->destination : null;
        $destination = Path::clean(JPATH_ROOT . '/layouts' . $folder);

        // Get source
        $folder = (string) $element->attributes()->folder;
        $source = ($folder && file_exists($installer->getPath('source') . '/' . $folder))
            ? $installer->getPath('source') . '/' . $folder : $installer->getPath('source');

        // Prepare files
        $copyFiles = [];
        foreach ($element->children() as $file)
        {
            $path['src']  = Path::clean($source . '/' . $file);
            $path['dest'] = Path::clean($destination . '/' . $file);

            // Is this path a file or folder?
            $path['type'] = $file->getName() === 'folder' ? 'folder' : 'file';
            if (basename($path['dest']) !== $path['dest'])
            {
                $newdir = dirname($path['dest']);
                if (!Folder::create($newdir))
                {
                    Log::add(Text::sprintf('JLIB_INSTALLER_ERROR_CREATE_DIRECTORY', $newdir), Log::WARNING, 'jerror');

                    return false;
                }
            }

            $copyFiles[] = $path;
        }
       return $installer->copyFiles($copyFiles, true);

    }

    /**
     * Method to parse through a layouts element of the installation manifest and remove the files that were installed.
     *
     * @param   SimpleXMLElement|null  $element  The XML node to process.
     *
     * @return  bool  True on success.
     *
     * @since  1.0.0
     */
    protected function removeLayouts(SimpleXMLElement $element = null): bool
    {
        if (!$element || !count($element->children()))
        {
            return false;
        }

        // Get the array of file nodes to process
        $files = $element->children();

        // Get source
        $folder = ((string) $element->attributes()->destination) ? '/' . $element->attributes()->destination : null;
        $source = Path::clean(JPATH_ROOT . '/layouts' . $folder);

        // Process each file in the $files array (children of $tagName).
        foreach ($files as $file)
        {
            $path = Path::clean($source . '/' . $file);

            // Actually delete the files/folders
            if (is_dir($path))
            {
                $val = Folder::delete($path);
            }
            else
            {
                $val = File::delete($path);
            }

            if ($val === false)
            {
                Log::add('Failed to delete ' . $path, Log::WARNING, 'jerror');

                return false;
            }
        }

        if (!empty($folder))
        {
            Folder::delete($source);
        }

        return true;
    }
};