<?php
/**
 * @package     Editor JS
 * @subpackage  EditorJS.category
 *
 * @copyright   (C) 2024 Alexandr Novikov, <https://joomlab.ru>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
 
namespace joomLab\Plugin\Content\CategoryEditorJS\Extension;

// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\Event\Event;
use Joomla\Event\SubscriberInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Event\Result\ResultAwareInterface;
use Joomla\CMS\Event\Content\ContentPrepareEvent;
use Joomla\Registry\Registry;

//преобразуем байты в КБ и Мб	
function convert_bytes($size)
{
	$i = 0;
	while (floor($size / 1024) > 0) {
		++$i;
		$size /= 1024;
	}
 
	$size = str_replace('.', ',', round($size, 1));
	switch ($i) {
		case 0: return $size .= ' байт';
		case 1: return $size .= ' КБ';
		case 2: return $size .= ' МБ';
	}
}

class CategoryEditorJS extends CMSPlugin implements SubscriberInterface
{
    public static function getSubscribedEvents(): array
    {
        return [
            'onContentPrepare' => 'PrepareCategory'
        ];
    }
	
    public function PrepareCategory(ContentPrepareEvent $event) {
		if($event->getContext() != 'com_content.category') return;
		
		//параметры плагина EditorJS
		$plugin = PluginHelper::getPlugin('editors','editorjs');
		$params = new Registry($plugin->params);
		$path_img = $params->get('path_img');
		$fancybox = $params->get('fancybox');
		$style = $params->get('style');
		$icons_path = $params->get('icons_path');

		$wa = Factory::getApplication()->getDocument()->getWebAssetManager();
		$wa->getRegistry()->addExtensionRegistryFile('plg_editors_editorjs');

		if($fancybox) {
			$wa->useStyle('plg_editors.fancybox.css');
			$wa->useScript('plg_editors.fancybox.js');
		}
		if($style) {
			$wa->useStyle('plg_editors.css');
		}
		
        $item = $event->getItem();
		
		$blocks = json_decode($item->text)->blocks;
		$html = '';
		foreach($blocks as $b => $block) {
			if($event->getContext() == 'com_content.category') { //если есть заголовок материала, показываем только вступительный текст материала
				if($b == 0) {
					if($block->type == 'paragraph') { //параграфф
						$html .= '<p id="'.$block->id.'">'.$block->data->text.'</p>';
					}
				}
			} else { //если заголовка материала нет, значит показываем описание категории категория
				if($block->type == 'paragraph') { //параграфф
					$html .= '<p id="'.$block->id.'">'.$block->data->text.'</p>';
				}
				if($block->type == 'header') { //заголовок
					$html .= '<h'.$block->data->level.' id="'.$block->id.'">'.$block->data->text.'</h'.$block->data->level.'>';
				}
				if($block->type == 'list') { //список ol
					if($block->data->style == 'ordered') {
						$html .= '<ol id="'.$block->id.'">';
					} else {
						$html .= '<ul id="'.$block->id.'">';
					}
					foreach($block->data->items as $li) {
						$html .= '<li>'.$li.'</li>';
					}
					if($block->data->style == 'ordered') {
						$html .= '</ol>';
					} else {
						$html .= '</ul>';
					}
				}
				if($block->type == 'table') { //таблица
					$html .= '<table id="'.$block->id.'"><tbody>';
						foreach($block->data->content as $tr) {
							$html .= '<tr>';
							foreach($tr as $td) {
								$html .= '<td>'.$td. '</td>';
							}
							$html.= '</tr>';
						}
					$html .='</tbody></table>';
					//print_r($block->data->content);
				}
				if($block->type == 'quote') { //цитата
					$html .= '<blockquote id="'.$block->id.'" class="blockquote">';
						$html .= '<p>'.$block->data->text.'</p>';
						$html .= '<cite>'.$block->data->caption.'</cite>';
					$html .= '</blockquote>';
				}
				if($block->type == 'image') { //изображения
					$html .= '<div class="editorjs_image" data-fancybox="category_gallery" data-src="'.str_replace("/mini","", $block->data->file->url).'" data-caption="'.$block->data->caption.'">';
						$html .= '<img src="'.$block->data->file->url.'" alt="" />';
						$html .= '<span class="editorjs_image-caption">'.$block->data->caption.'</span>';
					$html .= '</div>';
				}
				if($block->type == 'attaches') { //вложения
					$html .= '<div id="'.$block->id.'" class="editorjs_attach_block">';
						$html .= '<div class="editorjs_download_attach">Скачать вложение</div>';
						$html .= '<a href="'.$block->data->file->url.'" title="'.$block->data->file->name.'" target="_blank">';
						$html .= '<img src="'.$icons_path.'/'.$block->data->file->extension.'.png" alt="'.$block->data->file->extension.'" />';
						$html .= '<span class="editorjs_attach_name">';
							$html .= '<span>'.$block->data->file->name.'</span>';
							$html .= '<small>'.convert_bytes($block->data->file->size).'</small>';
							$html .= '</span>';
						$html .= '</a>';
					$html .= '</div>';
				}
				
				if($block->type == 'code') { //код
					$html .= '<pre><code">'.$block->data->code.'</code></pre>';
				}
				if($block->type == 'raw') { //rawHTML
					$html .= $block->data->html;
				}
			}
		}

		
		$html = $this->render($html);
		
		//экранируем html
		$strip_tags = "applet|body|bgsound|base|basefont|canvas|embed|frame|frameset|head|html|id|iframe|ilayer|layer|link|meta|name|object|script|style|title|xml";
		$clean_html = preg_replace("#<\s*\/?(".$strip_tags.")\s*[^>]*?>#im", '', $html);
	
		if($fancybox and $event->getContext() != 'mod_articles_category.content') {
			$clean_html .= '<script>Fancybox.bind("[data-fancybox]", {compact: false,});</script>';
		}
		$item->text = $clean_html;
    }
	private function render($text) {
		return $text;
	}
}