<?php

/**
 * @package     EditorJS
 * @subpackage  Editors.editor
 *
 * @copyright   (C) 2024 Alexandr Novikov. <https://www.joomlab.ru>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\FileLayout;
use Joomla\Registry\Registry;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Filter\OutputFilter;

extract($displayData);

HTMLHelper::_('jquery.framework');
$wa = Factory::getApplication()->getDocument()->getWebAssetManager();
$wa->getRegistry()->addExtensionRegistryFile('plg_editors_editorjs');
$wa->useScript('plg_editors.editor');
$wa->useScript('plg_editors.editor-style');
if($displayData['header']) { 
	$wa->useScript('plg_editors.header');
} 
if($displayData['list']) {
	$wa->useScript('plg_editors.list');
}
if($displayData['table']) {
	$wa->useScript('plg_editors.table');
}
if($displayData['quote']) { 
	$wa->useScript('plg_editors.quote');
}
if($displayData['image']) {
	$wa->useScript('plg_editors.image');
} 
if($displayData['attach']) {
	$wa->useScript('plg_editors.attach');
}
if($displayData['html']) { 
	$wa->useScript('plg_editors.html');
}
if($displayData['code']) { 
	$wa->useScript('plg_editors.code');
}


//$content = str_replace('&quot;', '"', $content);
$user = Factory::getUser();
$user_id = $user->id;

$input = Factory::getApplication()->input;
$item_id = $input->get('id', '', 'int');
if(!$item_id) { //если пользоваатель добавляет с фронта
	$item_id = $input->get('a_id', '', 'int');	
}
$view = $input->get('view', '', 'string');

$editor_id = str_replace(['[',']','-'],'',$name); 
?>
<style>
.ce-block__content,
.ce-toolbar__content {
	max-width:90%
}

#jform_articletext-lbl,
#jform_description-lbl,

.ce-popover-item[data-item-name='withBorder'],
.ce-popover-item[data-item-name='withBackground'],
.ce-popover-item[data-item-name='stretched']

{display:none}

</style>
<?php 
$content = htmlspecialchars_decode($content);

$arr = json_decode($content, JSON_HEX_QUOT);
if(json_last_error() and !empty($content)) { //сообщение если контент элемента не из EditorJS?>
	<div class="alert alert-danger"><?php echo Text::sprintf('PLG_EDITOR_NO_JSON') ?></div>
<?php return; }  ?>
<?php if(($displayData['path_id'] == 'allID' or $displayData['path_id'] == 'articleID') and !$item_id) { //если в путях для изображения нужно id элемента, то элемент сначала нужно сохранить?>
	<div class="alert"><?php echo Text::sprintf('PLG_EDITOR_NO_ITEM_ID') ?></div>
<?php } ?>

<joomla-editor-js>
	<div id="editor_<?php echo $editor_id ?>" name="editor_<?php echo $editor_id ?>"></div>
	<?php if($displayData['copyright']) { ?>
		<div style="font-size:12px;color:#83899f"><?php echo Text::sprintf('PLG_EDITOR_COPYRIGHT_TEXT') ?></div>
	<?php } ?>
	<?php echo '<textarea style="display:none" id="' . str_replace(['[',']','-'],'',$name) . '" name="' . $name . '">' . $content . '</textarea>'; ?>
</joomla-editor-js>


<script>
	
    const editor_<?php echo $editor_id ?> = new EditorJS({
        holder: 'editor_<?php echo $editor_id ?>',
		placeholder: '<?php echo Text::sprintf('PLG_EDITOR_PLACEHOLDER') ?>',
        tools: {
			<?php if($displayData['header']) { ?>
			header: {
			  class: Header, 
			  config: {
				placeholder: '<?php echo Text::sprintf('PLG_EDITOR_HEADER') ?>',
				levels: [2, 3, 4],
				defaultLevel: 2
			  }
			},
			<?php } ?>
			<?php if($displayData['list']) { ?>
            list: List,
			<?php } ?>
			<?php if($displayData['table']) { ?>
				table: {
				  class: Table,
				  withHeadings: true,
				  inlineToolbar: true,
				},
			<?php } ?>
			<?php if($displayData['quote'] > 0 ) { ?>
			quote: {
			  class: Quote,
			  inlineToolbar: true,
			  shortcut: '',
			  config: {
				quotePlaceholder: '<?php echo Text::sprintf('PLG_EDITOR_QUOTE_TEXT') ?>',
				captionPlaceholder: '<?php echo Text::sprintf('PLG_EDITOR_QUOTE_AUTHOR') ?>',
			  },
			},
			<?php } ?>
			<?php if(($displayData['path_id'] == 'allID' or $displayData['path_id'] == 'articleID') and $item_id) { ?>
				<?php if($displayData['image'] > 0 ) { ?>
				image: {
					class: ImageTool,
					config: {
						endpoints: {
						<?php if(Factory::getApplication()->getName() == 'administrator') { ?>
							byFile: '/plugins/editors/editorjs/file/image/upload_file_admin.php?view=<?php echo $view ?>&user_id=<?php echo $user_id ?>&item_id=<?php echo $item_id ?>&<?php echo Session::getFormToken() ?>=1', 
						<?php } else { ?>
							byFile: '/plugins/editors/editorjs/file/image/upload_file_site.php?view=<?php echo $view ?>&user_id=<?php echo $user_id ?>&item_id=<?php echo $item_id ?>&<?php echo Session::getFormToken() ?>=1', 
						<?php } ?>
						},
						captionPlaceholder: "<?php echo Text::sprintf('PLG_EDITOR_DESC_IMAGE') ?>",
						errorMessage : 'пююю',
					}
				},
				<?php } ?>
				<?php if($displayData['attach'] > 0 ) { ?>
				attaches: {
					class: AttachesTool,
					config: {
						<?php if(Factory::getApplication()->getName() == 'administrator') { ?>
							endpoint: '/plugins/editors/editorjs/file/attach/upload_attach_admin.php?user_id=<?php echo $user_id ?>&<?php echo Session::getFormToken() ?>=1', 
						<?php } else { ?>
							endpoint: '/plugins/editors/editorjs/file/attach/upload_attach_site.php?user_id=<?php echo $user_id ?>&<?php echo Session::getFormToken() ?>=1', 
						<?php } ?>
						buttonText: '<?php echo Text::sprintf('PLG_EDITOR_ADD_FILE') ?>',
						errorMessage : '<?php echo Text::sprintf('PLG_EDITOR_EXT_IMAGE_ERROR') ?> <?php echo $displayData['ext_attach'] ?> <?php echo Text::sprintf('PLG_EDITOR_SIZE_IMAGE_ERROR') ?> <?php echo $displayData['size_attach'] ?> <?php echo Text::sprintf('PLG_EDITOR_MB') ?>',
					},
				},
				<?php } ?>
			<?php } ?>
			<?php if($displayData['html']) { ?>
			raw: RawTool,
			<?php } ?>
			<?php if($displayData['code'] > 0 ) { ?>
			code: CodeTool,
			<?php } ?>
        },
		<?php if($content) {  
			
		?>
			data: <?php echo $content ?>,
		<?php } ?>
		
  i18n: {
    messages: {
      ui: {
        "blockTunes": {
          "toggler": {
            "Click to tune": "<?php echo Text::sprintf('PLG_EDITOR_CLICK_SETUP') ?>",
            "or drag to move": "<?php echo Text::sprintf('PLG_EDITOR_DROP') ?>"
          },
        },
        "inlineToolbar": {
          "converter": {
            "Convert to": "<?php echo Text::sprintf('PLG_EDITOR_CONVERT_IN') ?>"
          }
        },
        "toolbar": {
          "toolbox": {
            "Add": "<?php echo Text::sprintf('PLG_EDITOR_ADD') ?>"
          }
        },
		"popover": {
		  "Filter": "<?php echo Text::sprintf('PLG_EDITOR_SEARCH') ?>",
		  "Nothing found": "<?php echo Text::sprintf('PLG_EDITOR_SEARCH_NO') ?>",
		  "Convert to": "<?php echo Text::sprintf('PLG_EDITOR_CONVERT_IN') ?>"
		},
		  "toolNames": {
			"Text": "<?php echo Text::sprintf('PLG_EDITOR_TEXT') ?>",
			"Link": "<?php echo Text::sprintf('PLG_EDITOR_LINK') ?>",
			"Bold": "<?php echo Text::sprintf('PLG_EDITOR_BOLD') ?>",
			"Italic": "<?php echo Text::sprintf('PLG_EDITOR_NAKLON') ?>"
		  },
      },
  
      toolNames: {
        "Text": "<?php echo Text::sprintf('PLG_EDITOR_PARAGRAF') ?>",
        "Heading": "<?php echo Text::sprintf('PLG_EDITOR_TITLE') ?>",
		"Heading 2": "!!!",
        "List": "<?php echo Text::sprintf('PLG_EDITOR_LIST') ?>",
        "Warning": "<?php echo Text::sprintf('PLG_EDITOR_PRIMECHANIE') ?>",
        "Checklist": "<?php echo Text::sprintf('PLG_EDITOR_CHECKBOX') ?>",
        "Quote": "<?php echo Text::sprintf('PLG_EDITOR_QUOTE') ?>",
        "Code": "<?php echo Text::sprintf('PLG_EDITOR_CODE') ?>",
        "Delimiter": "<?php echo Text::sprintf('PLG_EDITOR_HR') ?>",
        "Raw HTML": "<?php echo Text::sprintf('PLG_EDITOR_HTML') ?>",
        "Table": "<?php echo Text::sprintf('PLG_EDITOR_TABLE') ?>",
        "Link": "<?php echo Text::sprintf('PLG_EDITOR_LINK') ?>",
        "Marker": "<?php echo Text::sprintf('PLG_EDITOR_MARKER') ?>",
        "Bold": "<?php echo Text::sprintf('PLG_EDITOR_BOLD') ?>",
        "Italic": "<?php echo Text::sprintf('PLG_EDITOR_KURSIV') ?>",
        "InlineCode": "<?php echo Text::sprintf('PLG_EDITOR_MONO') ?>",
		"Image": "<?php echo Text::sprintf('PLG_EDITOR_IMAGE') ?>",
		"Attachment": "<?php echo Text::sprintf('PLG_EDITOR_FILE') ?>"
      },

      tools: {
		"image" : {
			"Select an Image": "<?php echo Text::sprintf('PLG_EDITOR_VIBOR_IMAGE') ?>",
			"Caption": "<?php echo Text::sprintf('PLG_EDITOR_IMAGE_DESC') ?>", 
        },

        "warning": { // <-- 'Warning' tool will accept this dictionary section
          "Title": "<?php echo Text::sprintf('PLG_EDITOR_NAZVANIE') ?>",
          "Message": "<?php echo Text::sprintf('PLG_EDITOR_MESSAGE') ?>",
        },

        "link": {
          "Add a link": "<?php echo Text::sprintf('PLG_EDITOR_ADD_LINK') ?>"
        },
        "stub": {
          'The block can not be displayed correctly.': '<?php echo Text::sprintf('PLG_EDITOR_BLOCK_NO') ?>'
        },

      },

      blockTunes: {
        "delete": {
          "Delete": "<?php echo Text::sprintf('PLG_EDITOR_DELETE') ?>",
		  "Click to delete": "<?php echo Text::sprintf('PLG_EDITOR_DELETE1') ?>",
        },
        "moveUp": {
          "Move up": "<?php echo Text::sprintf('PLG_EDITOR_UP') ?>"
        },
        "moveDown": {
          "Move down": "<?php echo Text::sprintf('PLG_EDITOR_DOWN') ?>"
        }
      },
    }
  },

    });

$(document).ready(function(){
	$('.button-apply, .button-save, .btn-success, .btn-primary, button').hover(function() {
		editor_<?php echo $editor_id ?>.save().then((outputData) => {
			editorData_<?php echo $editor_id ?> = JSON.stringify(outputData);
			$('#<?php echo str_replace(['[',']','-'],'',$name) ?>').val(editorData_<?php echo $editor_id ?>);
		}).catch((error) => {
		  console.log('Saving failed: ', error)
		});
	});
});
</script>
