<?php

/**
 * Joomla! Content Management System
 *
 * @copyright  (C) 2023 Open Source Matters, Inc. <https://www.joomla.org>
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace joomLab\Plugin\Editors\Editorjs\Provider;

use Joomla\CMS\Application\CMSApplicationInterface;
use Joomla\CMS\Editor\AbstractEditorProvider;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Uri\Uri;
use Joomla\Event\DispatcherInterface;
use Joomla\Registry\Registry;
use Joomla\CMS\Language\Text;

/**
 * Editor provider class
 *
 * @since   5.0.0
 */
final class EditorjsProvider extends AbstractEditorProvider
{
    /**
     * A Registry object holding the parameters for the plugin
     *
     * @var    Registry
     * @since  5.0.0
     */
    protected $params;

    /**
     * The application object
     *
     * @var    CMSApplicationInterface
     *
     * @since  5.0.0
     */
    protected $application;

    /**
     * Class constructor
     *
     * @param   Registry                 $params
     * @param   CMSApplicationInterface  $application
     * @param   DispatcherInterface      $dispatcher
     *
     * @since  5.0.0
     */
    public function __construct(Registry $params, CMSApplicationInterface $application, DispatcherInterface $dispatcher)
    {
        $this->params      = $params;
        $this->application = $application;
        $this->setDispatcher($dispatcher);
		
    }

    /**
     * Return Editor name, CMD string.
     *
     * @return string
     * @since   5.0.0
     */
    public function getName(): string
    {
        return 'editorjs';
    }

    /**
     * Gets the editor HTML markup
     *
     * @param   string  $name        Input name.
     * @param   string  $content     The content of the field.
     * @param   array   $attributes  Associative array of editor attributes.
     * @param   array   $params      Associative array of editor parameters.
     *
     * @return  string  The HTML markup of the editor
     *
     * @since   5.0.0
     */
    public function display(string $name, $content = '', array $attributes = [], array $params = []): string
    {
        $displayData = [
			'name'    => $name,
			'content' => $content,
			
            'header' => $this->params->get('header',''),
			'list' => $this->params->get('list',''),
			'table' => $this->params->get('table',''),
			'quote' => $this->params->get('quote',''),
			'code' => $this->params->get('code',''),
			'html' => $this->params->get('html',''),
			'image' => $this->params->get('image',''),
			'ext_image' => $this->params->get('ext_image',''),
			'size_image' => $this->params->get('size_image',''),
			'attach' => $this->params->get('attach',''),
			'ext_attach' => $this->params->get('ext_attach',''),
			'size_attach' => $this->params->get('size_attach',''),
			'path_id' => $this->params->get('path_id',''),
			
			'copyright' => $this->params->get('copyright',''),
        ];

       return LayoutHelper::render('editors.editorjs.editorjs', $displayData, JPATH_PLUGINS . '/editors/editorjs/layouts');
    }
	

}
