<?php

/**
 * @package     Editor JS
 * @subpackage  EditorJS.article
 *
 * @copyright   (C) 2024 Alexandr Novikov, <https://joomlab.ru>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

\defined('_JEXEC') or die;

use Joomla\CMS\Extension\PluginInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;
use Joomla\Event\DispatcherInterface;
use joomLab\Plugin\Content\ArticleEditorJS\Extension\ArticleEditorJS;

return new class () implements ServiceProviderInterface {
    public function register(Container $container)
    {
        $container->set(
            PluginInterface::class,
            function (Container $container) {
                $plugin     = new ArticleEditorJS(
                    $container->get(DispatcherInterface::class),
                    (array) PluginHelper::getPlugin('content', 'editorjs_article')
                );
                $plugin->setApplication(Factory::getApplication());

                return $plugin;
            }
        );
    }
};