<?php

use Joomla\CMS\Factory;
use Joomla\Filesystem\File;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\Registry\Registry;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Image\Image;

define('_JEXEC', 1);
define('JPATH_BASE',$_SERVER['DOCUMENT_ROOT']);

require_once JPATH_BASE . '/includes/defines.php';
require_once JPATH_BASE . '/includes/framework.php';
require_once JPATH_BASE . '/libraries/InvertImg/autoload.php';

use Intervention\Image\ImageManager;
use Intervention\Image\Drivers\Imagick\Driver;
use Intervention\Image\Encoders\AutoEncoder;
use Intervention\Image\Encoders\WebpEncoder;

$container = \Joomla\CMS\Factory::getContainer();
$container->alias(\Joomla\Session\SessionInterface::class, 'session.web.site');
$app = $container->get(\Joomla\CMS\Application\AdministratorApplication::class);
\Joomla\CMS\Factory::$application = $app;
$app->createExtensionNamespaceMap();

Session::checkToken('get') or die('no_t');

$db = $container->get(Joomla\Database\DatabaseInterface::class);

$plugin = PluginHelper::getPlugin('editors','editorjs');
$params = new Registry($plugin->params);
$ext_image = $params->get('ext_image');
$size_image = $params->get('size_image') * 1024 * 1024;
$tmp_path = $params->get('tmp_path');
$path_img = $params->get('path_img');
$path_id = $params->get('path_id');
$mini_image = $params->get('mini_image');
$big_image = $params->get('big_image');

$watermark = $params->get('watermark');
$quality = $params->get('quality');
$opacity_watermark = $params->get('opacity_watermark');

$mini_watermark = explode('#', $params->get('mini_watermark'))[0];
$position_mini_watermark = $params->get('position_mini_watermark');
$margin_mini_watermark = $params->get('margin_mini_watermark');

$big_watermark = explode('#', $params->get('big_watermark'))[0];
$position_big_watermark = $params->get('position_big_watermark');
$margin_big_watermark = $params->get('margin_big_watermark');

$uri = Uri::getInstance();
$domen = $uri->getHost();

$input = Factory::getApplication()->input;
$file = $input->files->get('image', '');
$user_id = $input->get('user_id', '', 'int');
$item_id = $input->get('item_id', '', 'int');
$view = $input->get('view', '', 'string');

if(!$user_id) {
	return;
}

$manager = new ImageManager(new Driver());
?>

<?php
$filename = File::makeSafe($file['name']); //транслитерация
$filename = str_replace(' ', '_', $filename);//убираем пробелы

$fileSize = $file['size'];
$uploadedFileNameParts = explode('.',$filename);
$uploadedFileExtension = array_pop($uploadedFileNameParts);
$validFileExts = explode(',', $ext_image);
$extOk = false;
foreach($validFileExts as $key => $value){
	if( preg_match("/$value/i", $uploadedFileExtension ) ){
		$extOk = true;
	}
}
if ($extOk == false || !$validFileExts) {
	echo 'no_valid_image';
	return;
}
else if ( $fileSize > $size_image ){
	echo 'no_size_image';
	return;
}

//формируем директории для сохранения
	//временные файлы
	$tmp = JPATH_BASE . $tmp_path .'/'. $user_id;
	//место хранения
	$dop_path = '';
	if($path_id == 'userID' ) {
		$dop_path = '/' .$user_id;
	}
	if($path_id == 'articleID' ) {
		$dop_path = '/' .$item_id;
	}
	if($path_id == 'allID' ) {
		$dop_path = '/'. $user_id .'/'. $item_id;
	}
	$path = $path_img .'/'. $view . $dop_path;

	//создаем директории
	$dir = JPATH_BASE . $path .'/mini';
	if (!is_dir($dir)) {
		mkdir($dir, 0777, true); 
	}
	
//обрабатываем файл
$src = $file['tmp_name'];
$dest = JPATH_BASE . $path .'/'.$filename;
$new_filename = explode('.', $filename)[0].'.webp';
if(File::upload($src, $dest)) {
	//создаем мини-изображение
	$mini_width = explode('/', $mini_image)[0];
	$mini_height = explode('/', $mini_image)[1];
	$mini_position = explode(',', $margin_mini_watermark);
	
	$image = $manager->read($dest);
	if($watermark > 0) { 
		$image->cover($mini_width, $mini_height, 'center')->place(JPATH_BASE .'/'. $mini_watermark, $position_mini_watermark, $mini_position[0], $mini_position[1], $opacity_watermark)->toWebp($quality)->save($dir.'/'.$new_filename);
	} else {
		$image->cover($mini_width, $mini_height, 'center')->toWebp($quality)->save($dir.'/'.$new_filename);
	}
	
	//обрабатываем главное изображение
	$big_position = explode(',', $margin_big_watermark);
	
	$image1 = $manager->read($dest);
	if($big_image > 0) {
		$big_width = explode('/', $big_image)[0];
		$big_height = explode('/', $big_image)[1];
		//если меняем размер
		if($watermark > 0) { 
			$image1->cover($big_width, $big_height, 'center')->place(JPATH_BASE .'/'. $big_watermark, $position_big_watermark, $big_position[0], $big_position[1], $opacity_watermark)->toWebp($quality)->save(JPATH_BASE . $path .'/'.$new_filename);
		} else {
			$image1->cover($big_width, $big_height, 'center')->toWebp($quality)->save(JPATH_BASE . $path .'/'.$new_filename);
		}
	} else { //если размер оставляем без изменений
		if($watermark > 0) { 
			$image1->place(JPATH_BASE .'/'. $big_watermark, $position_big_watermark, $big_position[0], $big_position[1], $opacity_watermark)->toWebp($quality)->save(JPATH_BASE . $path .'/'.$new_filename);
		} else {
			$image1->toWebp($quality)->save(JPATH_BASE . $path .'/'.$new_filename);;
		}	
	}
	//удаляем оригинал (оставляем только webp)
	unlink($dest);
}

//загружам директорию и записываем json	для редактора

	$output = array();
	$output["success"] = 1;
	$output["file"]["url"] = 'https://'.$domen . $path .'/mini/' .$new_filename;
	$output["file"]["name"] = $new_filename;
	$output["file"]["title"] = $new_filename;
	$output["file"]["size"] = $fileSize;
	$output["file"]["extension"] = File::getExt($new_filename);
	print json_encode($output);


?>