<?php
/**
 * @package     joomLab.Plugin
 * @subpackage  System.Mailauthorstatecontent
 *
 * @copyright   (C) 2025 Alexandr Novikov. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

\defined('_JEXEC') or die;

use Joomla\CMS\Extension\PluginInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;
use Joomla\Event\DispatcherInterface;
use joomLab\Plugin\System\Mailauthorstatecontent\Extension\Mailauthorstatecontent;

return new class () implements ServiceProviderInterface {
    /**
     * Registers the service provider with a DI container.
     *
     * @param   Container  $container  The DI container.
     *
     * @return  void
     *
     * @since   1.0.0
     */
    public function register(Container $container): void
    {
        $container->set(
            PluginInterface::class,
            function (Container $container) {
                $plugin = new Mailauthorstatecontent(
                    $container->get(DispatcherInterface::class),
                    (array) PluginHelper::getPlugin('system', 'mailauthorstatecontent')
                );
                $plugin->setApplication(Factory::getApplication());
                return $plugin;
            }
        );
    }
};