<?php
/**
 * @package     joomLab\Module\ContactMap
 *
 * @copyright   Copyright (C) 2025 Alexandr Novikov. All rights reserved.
 * @license     GNU General Public License version 2 or later;
 */
 
defined('_JEXEC') or die;

use Joomla\CMS\Extension\Service\Provider\HelperFactory;
use Joomla\CMS\Extension\Service\Provider\Module;
use Joomla\CMS\Extension\Service\Provider\ModuleDispatcherFactory;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;

return new class() implements ServiceProviderInterface
{
    public function register(Container $container)
    {
        $container->registerServiceProvider( new ModuleDispatcherFactory('\\joomLab\\Module\\ContactMap'));
        $container->registerServiceProvider( new HelperFactory('\\joomLab\\Module\\ContactMap\\Site\\Helper'));
        $container->registerServiceProvider( new Module());
    }
};