<?php
/**
 * @package     joomLab\Module\ContactMap
 *
 * @copyright   Copyright (C) 2025 Alexandr Novikov. All rights reserved.
 * @license     GNU General Public License version 2 or later;
 */
namespace joomLab\Module\ContactMap\Site\Helper;

defined('_JEXEC') or die;
use Joomla\CMS\Factory;
use Joomla\Registry\Registry;
use Joomla\CMS\Helper\ModuleHelper;
use Joomla\CMS\Layout\LayoutHelper;
class ContactMapHelper
{
    public function metkaAjax() {
        $module = ModuleHelper::getModule('contact_map');
        $params = new Registry($module->params);
        $input = Factory::getApplication()->getInput();
        $key = $input->get('metka', 'metka0', 'string');
        return LayoutHelper::render('modules.contact_map.default', ['params' =>$params, 'key_metka' => $key]);
    }
    public function uploadAjax()
    {
        $module = ModuleHelper::getModule('contact_map');
        $params = new Registry($module->params);
        $metka = $params->get('metka', '', 'array');
        $icon_metka = $params->get('icon_metka', '', 'string');

        $features = [];
        foreach($metka as $key_metka => $m) {
            $coordinates = array_map('floatval', explode(',', $m->coord));
            $features[] = [
                'type' => 'Feature',
                'id' => $key_metka,
                'geometry' => [
                    'type' => 'Point',
                    'coordinates' => $coordinates,
                ],
                'properties' =>  [
                    'hintContent' => $m->title
                ],
                'options' => [
                    'preset' => $icon_metka
                ]
            ];
        }
        $json = [
            'type' => 'FeatureCollection',
            'features' => $features,
        ];
        return json_encode($json, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    }
}
