<?php 
/**
 * @package     joomLab\Module\ContactMap
 *
 * @copyright   Copyright (C) 2025 Alexandr Novikov. All rights reserved.
 * @license     GNU General Public License version 2 or later;
 */
defined('_JEXEC') or die;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;
use Joomla\CMS\Layout\LayoutHelper;

$wa = Factory::getApplication()->getDocument()->getWebAssetManager();
$wa->getRegistry()->addExtensionRegistryFile('mod_contact_map');
$wa->useStyle('mod_contact_map.css');

$moduleclass_sfx = $params->get('moduleclass_sfx', '','string');
$api_key = $params->get('api_key', '', 'string');
$height = $params->get('height', '', 'int');
$zoom = $params->get('zoom', '', 'int');
$loading_text = $params->get('loading_text', '', 'string');

$metka = $params->get('metka', '', 'array');
$center_map = $metka->metka0->coord;
$icon_metka = $params->get('icon_metka', '', 'string');
$icon_metka_active = $params->get('icon_metka_active', '', 'string');
$check_cluster = $params->get('check_cluster', '', 'string');
$icon_cluster = $params->get('icon_cluster', '', 'string');
$loading_text = $params->get('loading_text', '', 'string');
 ?>

<div class="<?php echo 'joomlab_contact_map ' . $moduleclass_sfx; ?>">
    <div id="contact_map_<?php echo $module->id ?>" class="contact_map" style="height:<?php echo $height ?>px">
        <div class="loading_text"><?php echo $loading_text ?></div>
    </div>
    <div id="contacts_<?php echo $module->id ?>" class="joomlab_contacts">
        <?php  echo LayoutHelper::render('modules.contact_map.default', ['params' => $params, 'module' => $module]); ?>
    </div>
</div>
<script>
    document.addEventListener("DOMContentLoaded", function() {
            var script = document.createElement('script');
            script.type = 'text/javascript';
            script.src = '//api-maps.yandex.ru/2.1/?apikey=<?php echo $api_key ?>&lang=ru_RU&onload=getYaMap';
            window.isYandexMapLoaded = true;
            document.getElementsByTagName('body')[0].appendChild(script);
    });

    function getYaMap() {
        var myMap = new ymaps.Map('contact_map_<?php echo $module->id ?>', {
                center: [<?php echo $center_map ?>],
                zoom: <?php echo $zoom ?>
            }, {
                searchControlProvider: 'yandex#search'
            }),
            objectManager = new ymaps.ObjectManager({
                // Чтобы метки начали кластеризоваться, выставляем опцию.
                clusterize: <?php echo $check_cluster ?>,
                // ObjectManager принимает те же опции, что и кластеризатор.
                gridSize: 32,
                clusterDisableClickZoom: false,
                openBalloonOnClick: false
            });

        objectManager.objects.options.set('preset', '<?php echo $icon_metka ?>');
        objectManager.clusters.options.set('preset', '<?php echo $icon_cluster ?>');
        myMap.geoObjects.add(objectManager);

        var selectedObjectId = null;
        // Обработчик события клика по метке
        objectManager.objects.events.add('click', function (e) {
            var objectId = e.get('objectId');
            var object = objectManager.objects.getById(objectId);

            var coordinates = object.geometry.coordinates;
            myMap.panTo(coordinates, {
                duration: 1000
            });

            var currentPreset = object.options.preset || '<?php echo $icon_metka ?>';
            objectManager.objects.setObjectOptions(objectId, { preset: '<?php echo $icon_metka_active ?>' });
            if (selectedObjectId !== null && selectedObjectId !== objectId) {
                var previousObject = objectManager.objects.getById(selectedObjectId);
                if (previousObject) {
                    var previousPreset = previousObject.properties.originalPreset || '<?php echo $icon_metka ?>';
                    objectManager.objects.setObjectOptions(selectedObjectId, { preset: previousPreset });
                }
            }
            objectManager.objects.setObjectOptions(objectId, { originalPreset: currentPreset });
            selectedObjectId = objectId;

            Joomla.request({
                url: 'index.php?option=com_ajax&module=contact_map&method=metka&format=raw&metka='+objectId,
                method: 'GET',
                onBefore(xhr) {
                    document.getElementById('contacts_<?php echo $module->id ?>').classList.add('loading');
                },
                onSuccess(data) {
                     document.getElementById('contacts_<?php echo $module->id ?>').innerHTML = data;
                },
                onComplete(xhr) {
                    document.getElementById('contacts_<?php echo $module->id ?>').classList.remove('loading');
                },
                onError(xhr) {
                    Joomla.renderMessages(Joomla.ajaxErrorsMessages(xhr));
                    const response = JSON.parse(xhr.response);
                    Joomla.renderMessages({ 'error': [response.message] }, undefined, true);
                }
            });
        });

        Joomla.request({
            url: 'index.php?option=com_ajax&module=contact_map&method=upload&format=json',
            method: 'GET',
            onSuccess(data) {
                const response = JSON.parse(data).data;
                objectManager.add(response);

                if (JSON.parse(response).features && JSON.parse(response).features.length > 0) {
                    var firstFeature = JSON.parse(response).features[0];
                    var firstObjectId = firstFeature.id;
                    var firstObject = objectManager.objects.getById(firstObjectId);
                    if (firstObject && firstObject.geometry) {
                        // Сохраняем текущий preset первой метки
                        var currentPreset = firstObject.options.preset || '<?php echo $icon_metka ?>';
                        objectManager.objects.setObjectOptions(firstObjectId, { preset: '<?php echo $icon_metka_active ?>' });
                        objectManager.objects.setObjectOptions(firstObjectId, { originalPreset: currentPreset });
                        selectedObjectId = firstObjectId;
                    }
                }
            },
            onError(xhr) {
                Joomla.renderMessages(Joomla.ajaxErrorsMessages(xhr));
                const response = JSON.parse(xhr.response);
                Joomla.renderMessages({ 'error': [response.message] }, undefined, true);
            }
        });
    }

</script>