<?php
/**
 * @package     joomLab.Plugin
 * @subpackage  Content.ImageModule
 *
 * @copyright   (C) 2025 Alexandr Novikov. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace joomLab\Plugin\Content\ImageModule\Extension;

defined('_JEXEC') or die;

use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Event\SubscriberInterface;
use Joomla\CMS\Form\Form;
use Joomla\Event\Event;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
class ImageModule extends CMSPlugin implements SubscriberInterface
{
    protected $autoloadLanguage = true;
    public static function getSubscribedEvents(): array
    {
        return [
            'onContentPrepareForm' => 'onContentPrepareForm',
	        'onAfterRenderModule' => 'onAfterRenderModule'
        ];
    }
    public function onContentPrepareForm(Event $event): void
    {
	    $form = $event->getArgument('0');
		if($form->getName() === 'com_modules.module') {
			$form->load('
                <form>
                    <fields name="params">
                        <fieldset name="imageparams" label="'.Text::_('PLG_CONTENT_IMAGE_MODULE_ICON').'">
                            <field
                                name="imagefile"
                                type="media"
                                label="'.Text::_('PLG_CONTENT_IMAGE_MODULE_ICON_VIBOR').'"
                            />
                        </fieldset>
                    </fields>
                </form>
            ');
		}
    }
	public function onAfterRenderModule(Event $event)
	{
		$module = $event->getModule()->module;
		if(!empty(json_decode($event->getModule()->params)->imagefile)) {
			$icon = json_decode($event->getModule()->params)->imagefile;
			$img_attribs = [
				'loading' => 'lazy',
				'class'=>'img-icon-module',
				'width'=>'auto',
				'height'=>'auto'
			];
			$header = json_decode($event->getModule()->params)->header_tag;
			$header = preg_quote($header, '/');

			$image = HTMLHelper::image($icon,'', $img_attribs);
			$modifiedContent = preg_replace('/<' . $header . '([^>]*)>/', '<' . $header . '$1>' . $image, $event->getModule()->content, 1);
			$event->getModule()->content = $modifiedContent;
		}
	}
}