<?php
namespace joomLab\Module\FavoriteList\Site\Helper;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\Database\DatabaseInterface;
use Joomla\CMS\Language\Text;
use Joomla\Component\Fields\Administrator\Helper\FieldsHelper;

class FavoriteListHelper
{
	public function getFavoriteList($params, $app)
	{
		$db = Factory::getContainer()->get(DatabaseInterface::class);
		$user_id = $app->getIdentity()->id;
		$list = [];
		$cookies = $app->input->cookie->getArray();
		if ($user_id == 0) {
			foreach ($cookies as $name => $value) {
				if (strpos($name, 'item_favorite') === 0) {
					$item_id = substr($name, strlen('item_favorite'));
					$query = $db->getQuery(true)
						->select(['id','title', 'alias', 'images', 'catid', 'language'])
						->from($db->quoteName('#__content'))
						->where($db->quoteName('id') . ' = ' . $db->quote($item_id));

					$db->setQuery($query);
					$article = $db->loadObject();
					if ($article) {
						$fields = FieldsHelper::getFields('com_content.article', ['id' => $item_id], true);
						$list[] = [
							'article' => $article,
							'fields' => $fields
						];
					}
				}
			}
		} else {
			$query = $db->getQuery(true)
				->select('item_id')
				->from($db->quoteName('#__joomlab_favorite'))
				->where($db->quoteName('user_id') . ' = ' . $db->quote($user_id));

			$db->setQuery($query);
			$favorites = $db->loadObjectList();
			if($favorites) {
				foreach($favorites as $item) {
					$item_id = $item->item_id;
					$query = $db->getQuery(true)
						->select(['id','title', 'alias', 'images', 'catid', 'language'])
						->from($db->quoteName('#__content'))
						->where($db->quoteName('id') . ' = ' . $db->quote($item_id));

					$db->setQuery($query);
					$article = $db->loadObject();
					if ($article) {
						$fields = FieldsHelper::getFields('com_content.article', ['id' => $item_id], true);
						$list[] = [
							'article' => $article,
							'fields' => $fields
						];
					}
				}
			}
		}

		return $list;
	}
}