document.addEventListener('DOMContentLoaded', function() {
    //клик по закладке
    const FavoriteButtons = document.querySelectorAll('.favorite_button');
    FavoriteButtons.forEach(button => {
        button.addEventListener('click', function(event) {
            event.preventDefault();
            const itemId = this.getAttribute('data-item-id');
            Joomla.request({
                url: '/index.php?option=com_ajax&plugin=FavoriteList&format=raw&group=content&task=clickFavorite&item_id=' + itemId,
                method: 'GET',
                onBefore: function (xhr) {
                    document.querySelector(`.favorite_button[data-item-id="${itemId}"]`).style.opacity = '0.6';
                },onSuccess: function(response) {

                    data = JSON.parse(response);
                    const itemId = data.item_id;
                    const mainFavoriteElement = document.querySelector(`.favorite_button[data-item-id="${itemId}"]`);
                    //меняем закладку
                    var imgElements = document.getElementsByClassName("favorite_image"+itemId);
                    for (var i = 0; i < imgElements.length; i++) {
                        imgElements[i].src = '/'+ data.img;
                    }
                    //меняем текст
                    const favoriteButton = document.querySelector(`.favorite_button[data-item-id="${itemId}"] span.tooltip-favorite`);
                    if (favoriteButton) {
                        favoriteButton.innerHTML = data.text;
                    }
                    const favoriteTextButton = document.querySelector(`.favorite_button[data-item-id="${itemId}"] span.text_article`);
                    if(favoriteTextButton) {
                        favoriteTextButton.innerHTML = data.text_article;
                    }

                    //пересчитываем общую сумму
                    var favoriteCountElement = document.querySelector(".favorite_count");
                    if(favoriteCountElement) {
                        var currentCount = parseInt(favoriteCountElement.textContent, 10);
                        if (!isNaN(currentCount)) {
                            if (data.action == 'plus') {
                                currentCount += 1;
                            }
                            if (data.action == 'minus') {
                                currentCount -= 1;
                            }
                            favoriteCountElement.textContent = currentCount;
                        }
                    }

                    if(data.item) {
                        //добавляем позицию в модуль
                        const favoriteList = document.querySelector('.mod_favorite_list');
                        favoriteList.insertAdjacentHTML('beforeend', data.item);
                        //удаляем сообщение, что в списке ничего нет
                        if (favoriteList.children.length > 0) {
                            const emptyMessage = document.querySelector('.empty-message');
                            if(emptyMessage) {
                                emptyMessage.innerHTML= '';
                            }
                        }
                    } else {
                        //удаляем из модуля
                        document.querySelector(`.item_favorite[data-item-id="${itemId}"]`).remove();
                        //проверяем, есть ли вложенные блоки
                        const favoriteList = document.querySelector('.mod_favorite_list');
                        if (!favoriteList || favoriteList.children.length === 0) {
                            document.querySelector('.empty-message').innerHTML = '<div class="empty_message_style">' + Joomla.Text._('MOD_FAVORITE_LIST_NO_ITEMS') + '</div>';
                        }
                    }
                    /*
                    //выводим системное сообщение
                    Joomla.renderMessages({
                       info: [data.message]
                    });
                    */
                },
                onError: function(xhr, status, error) {
                    console.error('Error:', error);
                },
                onComplete: function (xhr){
                    const itemElement =  document.querySelector(`.favorite_button[data-item-id="${itemId}"]`);
                    if (itemElement) {
                        itemElement.style.opacity = '1';
                    }
                }
            });
        });
    });
// Обработчик для удаления элементов, работающий с динамически загруженными элементами
    document.addEventListener('click', function(event) {
        if (event.target.closest('.delete_item')) {
            event.preventDefault();
            const button = event.target.closest('.delete_item');
            const itemId = button.getAttribute('data-item-id');

            Joomla.request({
                url: '/index.php?option=com_ajax&plugin=FavoriteList&format=raw&group=content&task=deleteFavorite&item_id=' + itemId,
                method: 'GET',
                onBefore: function(xhr) {
                    const itemElement = document.querySelector(`.item_favorite[data-item-id="${itemId}"]`);
                    if (itemElement) {
                        itemElement.style.opacity = '0.6';
                    }
                },
                onSuccess: function(response) {
                    try {
                        const data = JSON.parse(response);
                        const itemId = data.item_id;

                        // Меняем закладку
                        const imgElements = document.querySelectorAll(`.favorite_image${itemId}`);
                        imgElements.forEach(img => {
                            img.src = '/'+ data.img;
                        });

                        // Меняем текст
                        const favoriteButton = document.querySelector(`.favorite_button[data-item-id="${itemId}"] span.tooltip-favorite`);
                        if (favoriteButton) {
                            favoriteButton.innerHTML = data.text;
                        }
                        const favoriteTextButton = document.querySelector(`.favorite_button[data-item-id="${itemId}"] span.text_article`);
                        if(favoriteTextButton) {
                            favoriteTextButton.innerHTML = data.text_article;
                        }

                        // Пересчитываем общую сумму
                        const favoriteCountElement = document.querySelector(".favorite_count");
                        if (favoriteCountElement) {
                            const currentCount = parseInt(favoriteCountElement.textContent, 10);
                            if (!isNaN(currentCount)) {
                                if (data.action == 'minus') {
                                    favoriteCountElement.textContent = currentCount - 1;
                                }
                            }
                        }

                        // Удаляем из модуля
                        const itemToRemove = document.querySelector(`.item_favorite[data-item-id="${itemId}"]`);
                        if (itemToRemove) {
                            itemToRemove.remove();

                            // Проверяем, есть ли вложенные блоки
                            const favoriteList = document.querySelector('.mod_favorite_list');
                            if (!favoriteList || favoriteList.children.length === 0) {
                                const emptyMessage = document.querySelector('.empty-message');
                                if (emptyMessage) {
                                    emptyMessage.innerHTML = '<div class="empty_message_style">' + Joomla.Text._('MOD_FAVORITE_LIST_NO_ITEMS') + '</div>';
                                }
                            }
                        }
                    } catch (e) {
                        console.error('Error parsing response:', e);
                    }
                },
                onError: function(xhr, status, error) {
                    console.error('Error:', error);
                    const itemElement = document.querySelector(`.item_favorite[data-item-id="${itemId}"]`);
                    if (itemElement) {
                        itemElement.style.opacity = '1';
                    }
                },
                onComplete: function(xhr) {
                    const itemElement = document.querySelector(`.item_favorite[data-item-id="${itemId}"]`);
                    if (itemElement) {
                        itemElement.style.opacity = '1';
                    }
                }
            });
        }
    });

    //тултипы
    function handleMouseOver(e, parentClass, childClass) {
        if (!e.target) return;

        // Если навели на родителя (.open_support) или его дочерний элемент (кроме .mini_support)
        const parentElement = e.target.closest(parentClass);
        if (parentElement) {
            const childElement = parentElement.querySelector(childClass);
            if (childElement) {
                childElement.style.opacity = '1';
            }
        }
    }

    function handleMouseOut(e, parentClass, childClass) {
        if (!e.target) return;

        const parentElement = e.target.closest(parentClass);
        if (parentElement) {
            const childElement = parentElement.querySelector(childClass);
            if (childElement) {
                // Проверяем, не перешёл ли курсор на .mini_support_block или его детей
                const isMovingToChild = e.relatedTarget && (
                    e.relatedTarget === childElement ||
                    childElement.contains(e.relatedTarget)
                );

                // Если курсор ушёл не на .mini_support_block, скрываем
                if (!e.relatedTarget || !isMovingToChild) {
                    childElement.style.opacity = '0';
                }
            }
        }
    }
    document.addEventListener('mouseover', function(e) {
        handleMouseOver(e, '.open-tooltip-favorite', '.tooltip-favorite');
    });
    document.addEventListener('mouseout', function(e) {
        handleMouseOut(e, '.open-tooltip-favorite', '.tooltip-favorite');
    });
});