<?php
/**
 * @package     joomLab.Plugin
 * @subpackage  Content.FavoriteList
 *
 * @copyright   (C) 2025 Alexandr Novikov. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace joomLab\Plugin\Content\FavoriteList\Extension;

defined('_JEXEC') or die;

use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Event\SubscriberInterface;
use Joomla\Event\Event;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Factory;
use Joomla\Registry\Registry;
use Joomla\Database\DatabaseInterface;
use Joomla\CMS\Cache\Cache;
use Joomla\CMS\Environment\Browser;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Helper\ModuleHelper;
use Joomla\Component\Fields\Administrator\Helper\FieldsHelper;

class FavoriteList extends CMSPlugin implements SubscriberInterface
{
    protected $autoloadLanguage = true;
    public static function getSubscribedEvents(): array
    {
        return [
	        'onContentBeforeDisplay' => 'onContentBeforeDisplay',
	        'onAjaxFavoriteList' => 'onAjaxFavoriteList',
	        'onContentPrepare' => 'onContentPrepare'
        ];
    }
	public function onContentPrepare(Event $event) {
		if($event->getContext() == 'com_content.article' or $event->getContext() == 'com_content.category' or $event->getContext() == 'com_content.featured')
		{
			$app     = $this->getApplication();
			$user_id = $app->getIdentity()->id;
			if(empty($event->getItem()->id)) return;
			$item_id = $event->getItem()->id;
			if ($user_id > 0)
			{
				$cookies = $app->input->cookie;
				$cookie  = $cookies->get('item_favorite' . $item_id, '');
				if ($cookie)
				{
					//проверяем, есть ли в базе
					$db    = Factory::getContainer()->get(DatabaseInterface::class);
					$query = $db->getQuery(true)
						->select('COUNT(id)')
						->from('#__joomlab_favorite')
						->where($db->quoteName('item_id') . ' = :item_id')
						->where('(' . $db->quoteName('user_id') . ' = :user_id OR ' . $db->quoteName('cookie') . ' = :cookie)');

					$query->bind(':item_id', $item_id);
					$query->bind(':user_id', $user_id);
					$query->bind(':cookie', $cookie);
					$db->setQuery($query);
					$count = $db->loadResult();
					//если нет, записываем
					if ($count == 0)
					{
						$f          = new \stdClass();
						$f->id      = $db->insertid();
						$f->context = 'com_content.article';
						$f->user_id = $user_id;
						$f->item_id = $item_id;
						$f->cookie  = $cookie;
						$result     = $db->insertObject('#__joomlab_favorite', $f);
					}
				}
			}
		}
	}
	public function onContentBeforeDisplay(Event $event)
	{
		if($event->getContext() == 'com_content.article' or $event->getContext() == 'com_content.category' or $event->getContext() == 'com_content.featured') {
			$this->loadLanguage();
			$event->addResult($this->FavoriteList($event->getContext(), $event->getItem(), $event->getParams(), $event->getPage()));
		} else {
			return;
		}
	}
	public function FavoriteList($context, $item, $params, $limitstart = 0): string
	{
		$app = $this->getApplication();
		$user_id = $app->getIdentity()->id;
		$db = Factory::getContainer()->get(DatabaseInterface::class);
		$item_id = $item->id;
		$catid = $item->catid;
		$cookies = $app->input->cookie;
		$cookie = $cookies->get('item_favorite'.$item_id, '');

		$plugin = PluginHelper::getPlugin('content','favorite_list');
		$param_favorite = new Registry($plugin->params);

		//проверяем есть ли избранное у пользователя
		if ($user_id == 0) {
			if($cookies->get('item_favorite'.$item_id)) {
				$my_favorite = 1;
			} else {
				$my_favorite = 0;
			}
		} else {
			$query = $db->getQuery(true)
				->select('COUNT(id)')
				->from('#__joomlab_favorite')
				->where($db->quoteName('item_id') . ' = :item_id')
				->where('(' . $db->quoteName('user_id') . ' = :user_id OR ' . $db->quoteName('cookie') . ' = :cookie)');

			$query->bind(':item_id', $item_id);
			$query->bind(':user_id', $user_id);
			$query->bind(':cookie', $cookie);
			$db->setQuery($query);
			$my_favorite = $db->loadResult();
		}

		if($my_favorite > 0) {
			$favorite_img = $param_favorite->get('main_favorite_active');
			$favorite_text = Text::_('PLG_CONTENT_REMOVE_FAVORITE');
			$favorite_text_article = Text::_('PLG_CONTENT_REMOVE_FAVORITE_ARTICLE');
		} else {
			$favorite_img = $param_favorite->get('main_favorite');
			$favorite_text = Text::_('PLG_CONTENT_ADD_FAVORITE');
			$favorite_text_article = Text::_('PLG_CONTENT_ADD_FAVORITE_ARTICLE');
		}

		$path = PluginHelper::getLayoutPath('content', 'favorite_list');
		ob_start();
		include $path;
		$html = ob_get_clean();
		return $html;
	}
	public function onAjaxFavoriteList(Event $event)
	{
		$plugin     = PluginHelper::getPlugin('content', 'favorite_list');
		$param_favorite = new Registry($plugin->params);
		$db         = Factory::getContainer()->get(DatabaseInterface::class);

		$app     = $this->getApplication();
		$user_id = $app->getIdentity()->id;

		$input   = $app->input;
		$item_id = $input->get('item_id', 'int');
		$task = $input->get('task','string');

		foreach (['HTTP_CLIENT_IP',
			         'HTTP_X_FORWARDED_FOR',
			         'HTTP_X_FORWARDED',
			         'HTTP_FORWARDED_FOR',
			         'HTTP_FORWARDED',
			         'REMOTE_ADDR'] as $key)
		{
			if (!empty($ip = $app->getInput()->server->getString($key)))
			{
				break;
			}
		}
		$browser =  Browser::getInstance();
		$hash = md5($ip.':'.$browser->getAgentString());

		$cookies = $app->input->cookie;
		$cookie = $cookies->get('item_favorite'.$item_id, '');
		$context = 'com_content.article';

		if($task == 'clickFavorite') {
			//проверяем есть ли материал в избранном
			if ($user_id == 0) {
				if($cookies->get('item_favorite'.$item_id)) {
					$count_favorite = 1;
				} else {
					$count_favorite = 0;
				}
			} else {
				$query = $db->getQuery(true)
					->select('COUNT(id)')
					->from('#__joomlab_favorite')
					->where($db->quoteName('item_id') . ' = :item_id')
					->where('(' . $db->quoteName('user_id') . ' = :user_id OR ' . $db->quoteName('cookie') . ' = :cookie)');

				$query->bind(':item_id', $item_id);
				$query->bind(':user_id', $user_id);
				$query->bind(':cookie', $cookie);
				$db->setQuery($query);
				$count_favorite = $db->loadResult();
			}

			if($count_favorite == 0 and $cookie != $hash) {
				//если нет - добавляем
				$expire = time() + (10 * 365 * 24 * 60 * 60);
				$cookies->set('item_favorite'.$item_id, $hash, $expire, '/', '', false, true);

				if($user_id > 0)
				{
					$f          = new \stdClass();
					$f->id      = $db->insertid();
					$f->context = $context;
					$f->user_id = $user_id;
					$f->item_id = $item_id;
					$f->cookie  = $hash;
					$result     = $db->insertObject('#__joomlab_favorite', $f);
				}

				//получаем данные для добавления в модуль
				$query = $db->getQuery(true)
					->select(['id', 'title', 'images', 'catid', 'alias', 'language'])
					->from($db->quoteName('#__content'))
					->where($db->quoteName('id') . ' = ' . $db->quote($item_id));

				$db->setQuery($query);
				$article = $db->loadObject();
				$fields = FieldsHelper::getFields('com_content.article', ['id' => $item_id], true);
				$list[] = [
					'article' => $article,
					'fields' => $fields
				];

				//формируем ответ
				$main_img = $param_favorite->get('main_favorite_active');
				$text = Text::_('PLG_CONTENT_REMOVE_FAVORITE');
				$text_article = Text::_('PLG_CONTENT_REMOVE_FAVORITE_ARTICLE');
				$message = Text::_('PLG_CONTENT_ADD_FAVORITE_MESSAGE');
				$action = 'plus';
				$item = $list[0];
				ob_start();
				require ModuleHelper::getLayoutPath('mod_favorite_list', 'default_item');
				$html = ob_get_clean();
			}
			//если есть - удаляем
			if($count_favorite > 0 or $cookie == $hash) {
				$cookies->set('item_favorite'.$item_id, '');
				if ($user_id == 0) {
					$query = $db->getQuery(true)
						->delete('#__joomlab_favorite')
						->where($db->quoteName('context') . ' = :context')
						->where($db->quoteName('item_id') . ' = :item_id')
						->where($db->quoteName('cookie') . ' = :cookie');

					$query->bind(':context', $context);
					$query->bind(':item_id', $item_id);
					$query->bind(':cookie', $cookie);
				} else {
					$query = $db->getQuery(true)
						->delete('#__joomlab_favorite')
						->where($db->quoteName('context') . ' = :context')
						->where($db->quoteName('item_id') . ' = :item_id')
						->where('(' . $db->quoteName('user_id') . ' = :user_id OR ' . $db->quoteName('cookie') . ' = :cookie)');

					$query->bind(':context', $context);
					$query->bind(':item_id', $item_id);
					$query->bind(':user_id', $user_id);
					$query->bind(':cookie', $cookie);
				}

				$db->setQuery($query);
				$db->execute();

				$main_img = $param_favorite->get('main_favorite');
				$text = Text::_('PLG_CONTENT_ADD_FAVORITE');
				$text_article = Text::_('PLG_CONTENT_ADD_FAVORITE_ARTICLE');
				$message = Text::_('PLG_CONTENT_REMOVE_FAVORITE_MESSAGE');
				$action = 'minus';
				$html = '';
			}
			$response = [
				'item_id' => $item_id,
				'img' => $main_img,
				'text' => $text,
				'text_article' => $text_article,
				'message' => $message,
				'action' =>  $action,
				'item' => $html
			];
			$response = json_encode($response);
			$event->addResult($response);
		}

		if($task == 'deleteFavorite') {
			$cookies->set('item_favorite'.$item_id, '');
			if ($user_id == 0) {
				$query = $db->getQuery(true)
					->delete('#__joomlab_favorite')
					->where($db->quoteName('context') . ' = :context')
					->where($db->quoteName('item_id') . ' = :item_id')
					->where($db->quoteName('cookie') . ' = :cookie');

				$query->bind(':context', $context);
				$query->bind(':item_id', $item_id);
				$query->bind(':cookie', $cookie);
			} else {
				$query = $db->getQuery(true)
					->delete('#__joomlab_favorite')
					->where($db->quoteName('context') . ' = :context')
					->where($db->quoteName('item_id') . ' = :item_id')
					->where('(' . $db->quoteName('user_id') . ' = :user_id OR ' . $db->quoteName('cookie') . ' = :cookie)');

				$query->bind(':context', $context);
				$query->bind(':item_id', $item_id);
				$query->bind(':user_id', $user_id);
				$query->bind(':cookie', $cookie);
			}

			$db->setQuery($query);
			$db->execute();

			$main_img = $param_favorite->get('main_favorite');
			$text = Text::_('PLG_CONTENT_ADD_FAVORITE');
			$message = Text::_('PLG_CONTENT_REMOVE_FAVORITE_MESSAGE');
			$action = 'minus';
			$html = '';

			$response = [
				'item_id' => $item_id,
				'img' => $main_img,
				'text' => $text,
				'message' => $message,
				'action' =>  $action,
				'item' => $html
			];
			$response = json_encode($response);
			$event->addResult($response);
		}

		//чистим кэш
		$cache = Cache::getInstance();
		$cache->clean('com_content');
	}
}