<?php defined('_JEXEC') or die;
/**
 * @package     joomLab.Plugin
 * @subpackage  Content.Like
 *
 * @copyright   (C) 2025 Alexandr Novikov. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;

$wa = Factory::getApplication()->getDocument()->getWebAssetManager();
$wa->getRegistry()->addExtensionRegistryFile('plg_content_favorite_list');
$wa->useStyle('favorite_list.css');
$wa->useScript('favorite_list.js');
?>
<?php if($context == 'com_content.article') { ?>
    <div class="favorite_button article_favorite_button" data-item-id="<?php echo $item->id ?>">
        <div class="open-tooltip-favorite">
            <?php  echo HTMLHelper::image($favorite_img, '', ['loading'=>'lazy','class'=>'favorite_image'.$item_id]); ?>
            <span class="text_article"><?php echo $favorite_text_article ?></span>
            <span class="tooltip-favorite"><?php echo $favorite_text ?></span>
        </div>
    </div>
<?php } else { ?>
    <div class="favorite_button" data-item-id="<?php echo $item->id ?>">
        <div class="open-tooltip-favorite">
			<?php  echo HTMLHelper::image($favorite_img, '', ['loading'=>'lazy','class'=>'favorite_image'.$item_id]); ?>
            <span class="tooltip-favorite"><?php echo $favorite_text ?></span>
        </div>
    </div>
<?php } ?>
